#define XRS_SOURCE
#include <XRS/window.h>
#include <XRS/string_format.h>
#include <XRS/define.h>
#undef XRS_SOURCE


//****************** class window ***************************

#define extractI(n,c,x) if(extractOpt(rDB,n,c,opt)) x=atoi(opt);if(x<0) x=0

void window::initialize(int i0,int j0,int m,int bw){
//------------- fBtHgl̎擾  ---------------
   int Window_Boder_Width;
   Window_Boder_Width=WINDOW_BODER_WIDTH;
   char opt[126];
   extractI("xrs.window.boder_width",
            "Xrs.Window.Boder_Width",Window_Boder_Width);
//----------------------------------------------------
 
   if(i0<0) i0=0; if(j0<0) j0=0;
   if(w <1)  w=1; if(h <1)  h=1;
   if(bw<0) bw=Window_Boder_Width;
   if(d==NULL) win=0; else win=XCreateSimpleWindow(d,r,i0,j0,w,h,bw,black,white);
   eventmask(ButtonPressMask);
   if(XRS_map && m) map();  
   XRS_list.push(this);
}


window::window(char *display_name,char *rcfile):rDB(NULL),chev(0){
   map_state=1;
   d=NULL; r=0;

   if(!display_name || strcmp(display_name,"&")){
      if((d=XOpenDisplay(display_name))==NULL){
           if(display_name==NULL) fprintf(stderr,"can't open DISPLAY.\n");
           else           fprintf(stderr,"can't open %s.\n",display_name);
           exit(1); 
      }

      w=DisplayWidth(d, 0);
      h=DisplayHeight(d, 0);
      win = RootWindow(d, 0);
      cm = DefaultColormap(d, 0);
      black = BlackPixel(d, 0); 
      white = WhitePixel(d, 0);

     if(rcfile==NULL)  mergeDatabases(d,rDB,XRS_RESOURCE_FILE);
     else              mergeDatabases(d,rDB,rcfile);
   }
}


window::window(window &W,int wi,int he,int i,int j,int bw,int m):
  w(wi),h(he),name(NULL),map_state(m),
  d(W.disp()),r(W),rDB(W.rDB),cm(W.cm),black(W.black),white(W.white),chev(0)
{ initialize(i,j,m,bw); }


window::window(int i,int j,int m):
 w(i),h(j),name(NULL),map_state(m),
 d(XRS_ROOT.disp()),r(XRS_ROOT),rDB(XRS_ROOT.rDB),cm(XRS_ROOT.cm),
 black(XRS_ROOT.black),white(XRS_ROOT.white),chev(0)
{ initialize(-1,-1,m,-1); }


window::~window(){
   if(r){
      register int n=XRS_list.number()-1;
      for(ListIter<window*> i(XRS_list,-1); !i.empty(); i.prev()){
        if(i.curr()==this) break;
        n--;
      }
      XRS_list.splice(n);
      if(name!=NULL) delete [] name;
      if(d) XDestroyWindow(d,win);
   }else{
      if(d) XCloseDisplay(d);
   }
}

void window::map(void){
   if(d && r){ 
       XWindowAttributes attribs;
       XGetWindowAttributes(d,win,&attribs);
       if(attribs.map_state==IsUnmapped){
          int evm;  evm=eventmask();
          eventmask(StructureNotifyMask);
          XMapRaised(d,win); map_state=1;
          while(1){
             XWindowEvent(d,win,StructureNotifyMask,&ev);  
             if(ev.type == MapNotify) break;
          }
          eventmask(evm);
          if(XRS_map) redraw(); else draw();
       }
   }
}


void window::title(char *s){
  if(r){ copy_string(name,s); if(d) XStoreName(d,win,name);  }
}

void window::move(int i,int j){
  if( i<0 && j<0 ) return;
  if(d && r){
     int x,y; unsigned int wi,he,bw,depth; Window root;
     XGetGeometry(d,win,&root,&x,&y,&wi,&he,&bw,&depth);
     if( i==x && j==y ) return;
     if( i<0 ) i=x;     if( j<0 ) j=y;
     XMoveWindow(d,win,i,j);
  }  
}

void window::resize(int i,int j){ 
  if(r){
     int evm;  
     if(i<1) i=w;  if(j<1) j=h;  
     if(w==i && h==j) return;
     w=i; h=j; 
     if(d==NULL) return;
     if(map_state){
       evm=eventmask();
       eventmask(StructureNotifyMask);
       XResizeWindow(d,win,w,h);
       while(1){
          XWindowEvent(d,win,StructureNotifyMask,&ev);  
          if(ev.type == ConfigureNotify)
             if(ev.xconfigure.width==i && ev.xconfigure.height==j) break;
       }
       eventmask(evm);
     }else{
       if(d) XResizeWindow(d,win,w,h);
     }
  }
}


//**************** initialize/checkevent ֐ ********************

void initialize(void){ 
  for(ListIter<window*> i=XRS_list; !i.empty(); i.next())
      if(i.curr()->map_state) i.curr()->map();
  XRS_map=1;
  for(ListIter<window*> j=XRS_list; !j.empty(); j.next()) j.curr()->startup();
}


void checkevent(void){
    for(ListIter<window*> i=XRS_list; !i.empty(); i.next())
      i.curr()->checkevent();
}
