/*==========================================================================
   Xwindow Realtime Simulator ver.3 Sample ( Complex )
   by kitsune(originated by sasa (originated by gutchi (originated in WTNB)))
============================================================================

    GCGL equation
      dW/dt=W-c2*norm(W)*W+K*c1*(<W>-W)
      real(c1)=real(c2)=1.0;  <W>= average of W;

---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <XRS/Complex_Control.h>
#include <XRS/Simple.h>

//#define  RANDOM   ((double)random()/2147483647)
#define  RANDOM   drand48()
#define  DISPSTEP 100
#define  WIDTH    200
#define  N        1000

/*************** grobal variable *****************/

Complex c1(1,2),c2(1,-2);
double  DT=0.05,Amp=0.3,t,K=0.5;
int     Initial=0;
Complex w[N];


/*************** function prototype ******************/

//extern "C" int random(void);
inline Complex field();
void           initial(int);
void           draw();

Complex_Control_Window Cwin;
Simple_Window          Win(WIDTH,WIDTH);


main(){
   register int n,ts;
   Complex v;

   Cwin<<t<<"t"<<PC<<v<<"O.P."<<RC
       <<initial<<"initial"<<PARAMETER<<c2<<"c2"<<c1<<"c1"<<K<<"K"<<Amp<<"Amp";
   Win<<"GCGL snapshot";
   initialize();

   initial(0);
   while(1){
      for(ts=0; ts<DISPSTEP;ts++){
         v=field();
         for(n=0; n<N; n++)
            w[n]+=DT*( (1-c2*norm(w[n]))*w[n]+K*c1*(v-w[n]) );
      }
      t+=DT*DISPSTEP;  checkevent(); draw();
   }
}


void initial(int){
   for(register int n=0; n<N; n++) w[n]=polar(RANDOM,2*M_PI*RANDOM);
   t=0; Initial=1;
}


inline Complex field(){
   Complex w0=0; for(register int n=0; n<N; n++) w0+=w[n]; 
   return w0/N; 
}


#define I(x)  (int)(WIDTH*(Amp*(x)+0.5))
void draw(void){
   register int n;
   static XPoint point[N];

   if(Initial){ 
      for(n=0; n<N; n++) point[n].x=point[n].y=0;
      Win.clear(); Initial=0; 
   }else{
      XDrawPoints(Win.disp(),Win,Win.wgc,point,N,CoordModeOrigin);
   }

   for(n=0; n<N; n++){
      point[n].x=I(w[n].real());  
      point[n].y=I(w[n].imag());
   }
   XDrawPoints(Win.disp(),Win,Win.bgc,point,N,CoordModeOrigin);
}




