/*==========================================================================
   Xwindow Realtime Simulator ver.3 Sample (1D simulation)
   by kitsune(originated by sasa (originated by gutchi (originated in WTNB)))
============================================================================

  This model is a simple excitable system. 
  It's behavior for large diffusion constant was showed by Ryo Kobayashi.   

     du/dt = f(u) - v + Laplacian(u)
     dv/dt = u + D * Laplacian(v)

-----------------------------------------------------------------------------*/


/*********** include **************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <XRS/Control.h>
#include <XRS/Plane.h>


/*********** define ***************/

#define MAX         1001
#define f(u)        (-u+0.5*(tanh((u-a)/delta)+tanh(a/delta)))
#define integer(x)  ((int)(floor(x)+floor(2*((x)-floor(x)))))


/*********** global variable ************/

double                  t;
double                  u[MAX],v[MAX];

double                  LX=500;
double                  DT=0.05;
double                  DX=0.5;
double                  quit_time=10000.0;

double                  a=0.1;
double                  D=1.0;
double                  delta=0.05;
double                  r_start=5.0;
double                  u_start=2.5;

int                     i_max,j_max;

Display                 *d;
GC                      black,blue,white;


/********** function & class prototype *****************/

void                    initial(int);
void                    win_draw();
Control_Window          Cwin;
Plane_Window            win;

main()
{
     register int i;

     i_max = (int)(LX/DX);
     j_max = 100;

/*----- initialize ----------*/

     Cwin<<t<<"t"<< initial <<PARAMETER<< a << D << delta << u_start << r_start
                 <<"initial"<<"a"<<"D"<<"delta"<<"u_start"<<"r_start";
     win.geometry(i_max,j_max)<<"u(red) and v(green)"<<COLOR();

     initialize();

     d=win.disp();
     black=win.bgc;
     white=win.wgc;
     blue =graphic_context(color_pixel("blue"));

     initial(0);

/*----- main routine --------*/

     double   v2[MAX],u2[MAX];
     double   du,dv,txx;
     txx=DT/(DX*DX);

     while(1){
      
         checkevent();
 
         for(i=1;i<i_max;i++){
             du=u[i-1]+u[i+1]-2.0*u[i]; 
             u2[i]=u[i]+txx*du+DT*(f(u[i])-v[i]);
         }

         for(i=1;i<i_max;i++){
             dv=v[i-1]+v[i+1]-2.0*v[i];
             v2[i]=v[i]+txx*D*dv+DT*u[i];
         }

         for(i=1;i<i_max;i++){
             v[i]=v2[i];
             u[i]=u2[i];
         }
             
         v[0]=v[1];
         v[i_max]=v[i_max-1];
         u[0]=u[1];
         u[i_max]=u[i_max-1];

         t = t + DT;

         if(t >= quit_time) break;

         win_draw();
    }
}


/*************** initialize function ************/

void initial(int)
{
    register i;
    t=0;

    for(i=0; i<i_max+1; i++){
       u[i] = 0.0;
       v[i] = 0.0;
    }

    for(i=0; i<i_max; i++)
       if(fabs((double)i-(double)i_max/2)<(r_start/DX)) u[i] = u_start;
}


//************** window draw **************

void win_draw(void)
{
    register int i,j;
    static int ju[MAX],jv[MAX];

    for(i=0; i<i_max; i++){
       j=(int)((double)j_max*(0.75-0.7*u[i]/u_start));
       if(j!=ju[i]){
         win.erase_point(0,i,ju[i]);
         win.draw_point(0,i,j); ju[i]=j;
       }

       j=(int)((double)j_max*(0.75-0.7*v[i]/u_start));
       if(j!=jv[i]){
         win.erase_point(1,i,jv[i]); 
         win.draw_point(1,i,j); jv[i]=j;
       }
    }
}



