#define XRS_SOURCE
#include <XRS/i_dialog.h>
#include <XRS/color.h>
#include <XRS/string_format.h>
#include <XRS/define.h>
#undef XRS_SOURCE


//************** class i_dialog ********************

#define extractZ(n,c,x) if(extractOpt(win.rDB,n,c,opt)) x=atoi(opt);if(x<1) x=1
#define extractI(n,c,x) if(extractOpt(win.rDB,n,c,opt)) x=atoi(opt);if(x<0) x=0
#define extractS(n,c,x) if(extractOpt(win.rDB,n,c,opt)) copy_string(x,opt)


void i_dialog::initialize(){

//------------- fBtHgl̎擾  ---------------
   
   int   I_Dialog_Step;
   char *I_Dialog_Color,*I_Dialog_Format,*I_Dialog_Font;
   I_Dialog_Color=I_Dialog_Format=I_Dialog_Font=NULL;

   I_Dialog_String =I_DIALOG_STRING;
   I_Dialog_Xoffset=I_DIALOG_XOFFSET;
   I_Dialog_Yoffset=I_DIALOG_YOFFSET;
   I_Dialog_Width  =I_DIALOG_WIDTH;
   I_Dialog_Height =I_DIALOG_HEIGHT;
   I_Dialog_Shape  =I_DIALOG_SHAPE;
   I_Dialog_Step   =I_DIALOG_STEP;
   copy_string(I_Dialog_Font,I_DIALOG_FONT);   
   copy_string(I_Dialog_Color,I_DIALOG_COLOR);
   copy_string(I_Dialog_Format,I_DIALOG_FORMAT);

   char opt[126];

   extractZ("xrs.dialog.int.width",
            "Xrs.Dialog.Int.Width",I_Dialog_Width); 

   extractZ("xrs.dialog.int.height",
            "Xrs.Dialog.Int.Height",I_Dialog_Height); 

   extractI("xrs.dialog.int.xoffset",
            "Xrs.Dialog.Int.Xoffset",I_Dialog_Xoffset); 

   extractI("xrs.dialog.int.yoffset",
            "Xrs.Dialog.Int.Yoffset",I_Dialog_Yoffset); 

   extractI("xrs.dialog.int.shape",
            "Xrs.Dialog.Int.Shape",I_Dialog_Shape); 

   extractZ("xrs.dialog.int.string",
            "Xrs.Dialog.Int.String",I_Dialog_String); 

   extractZ("xrs.dialog.int.step",
            "Xrs.Dialog.Int.Step",I_Dialog_Step);

   extractS("xrs.dialog.int.color",
            "Xrs.Dialog.Int.Color",I_Dialog_Color);

   extractS("xrs.dialog.int.format",
            "Xrs.Dialog.Int.Format",I_Dialog_Format);

   extractS("xrs.dialog.int.font",
            "Xrs.Dialog.Int.Font",I_Dialog_Font);

//----------------------------------------------

   gc       = graphic_context(win,win.black,0,LineSolid,I_Dialog_Font);
   digit_gc = graphic_context(win,I_Dialog_Color,0,LineSolid,I_Dialog_Font);

   resize();

   step=I_Dialog_Step;
   format(I_Dialog_Format);

   delete [] I_Dialog_Font;    I_Dialog_Font=NULL;
   delete [] I_Dialog_Format;  I_Dialog_Format=NULL;
   delete [] I_Dialog_Color;   I_Dialog_Color=NULL;
}


i_dialog::~i_dialog(){ 
   delete [] pformat; pformat=NULL;
}


void i_dialog::resize(int i,int j,int s){
   
   if(i>0) I_Dialog_Width=i; if(j>0) I_Dialog_Height=j;
   if(s>=0) I_Dialog_Shape=s;
   
   switch(I_Dialog_Shape){ 
      case 0:  
        w=  I_Dialog_Width;    i1=1; i2=w-2; 
        h=2*I_Dialog_Height;   j1=j2=I_Dialog_Height; break;
      default:  
        w=2*I_Dialog_Width;    i1=i2=I_Dialog_Width;
        h=  I_Dialog_Height;   j1=1; j2=h-2;
   }   
}


void i_dialog::format(char *s){
  if(win.disp() && fw){
      char wanya[64]; int i;
      for(i=0;i<fw;i++) wanya[i]=' '; wanya[i]='\0';
      XDrawImageString(win.disp(),win,gc,i0+i1+I_Dialog_Xoffset,
                             j0+h-I_Dialog_Yoffset,wanya,fw); fw=0;
  }
  if(!s) return;  copy_string(pformat,s);  
}


void i_dialog::parameter_draw(){
   if(win.disp()==NULL) return;
   char wanya[64],desu[64];
   int i=parameter_string(wanya,desu,f,step,pformat);
   if(i>fw) fw=i;
   else{ for(;i<fw;i++) wanya[i]=desu[i]=' '; wanya[i]=desu[i]='\0';}
   
   XDrawImageString(win.disp(),win,gc,i0+i1+I_Dialog_Xoffset,
                    j0+h-I_Dialog_Yoffset,wanya,fw);
   XDrawString(win.disp(),win,digit_gc,i0+i1+I_Dialog_Xoffset,
                    j0+h-I_Dialog_Yoffset,desu,fw);
}

void i_dialog::draw(){
   if(win.disp()==NULL) return;
   static int f_old=f+1;
   if(f!=f_old){
     char wanya[64];
     int i=sprintf(wanya,pformat,f);
     if(i>fw) fw=i; else{ for(;i<fw;i++) wanya[i]=' '; wanya[i]='\0'; }

     XDrawImageString(win.disp(),win,gc,i0+i1+I_Dialog_Xoffset,
                    j0+h-I_Dialog_Yoffset,wanya,fw);
     f_old=f;
   }
}


void i_dialog::checkevent()
{ 
   register int x=win.ev.xbutton.x,y=win.ev.xbutton.y; chev=0;
   if(x>i0 && x<i0+w && y>j0 && y<j0+h){
      register int n=win.ev.xbutton.button;
      if(x<i0+i2 && y<j0+j2){
          switch(n){        /* parameter up */
            case 1: f+=step*10; break;
            case 2: f+=step;    break;
            case 3: step*=10;   break;   
            default:; 
          }
          chev=1;
      }else{
          switch(n){        /* parameter down */
            case 1: f-=step*10;          break;
            case 2: f-=step;             break;
            case 3: if(step>=10) step/=10; break;   
            default:;
          }
          chev=2;
      }
      parameter_draw(); 
    }
}


void i_dialog::redraw(){
   if(win.disp()==NULL) return;
   char wanya[I_Dialog_String+1];
   ::string(wanya,name,I_Dialog_String);
   XDrawRectangle(win.disp(),win,gc,i0+1,j0+1,w-2,h-2);
   XDrawLine(win.disp(),win,gc,i0+i1,j0+j1,i0+i2,j0+j2);
   XDrawImageString(win.disp(),win,gc,
    i0+I_Dialog_Xoffset,j0+j2-I_Dialog_Yoffset,wanya,I_Dialog_String);
   parameter_draw();
   XFlush(win.disp());
}

