#define XRS_SOURCE
#include <XRS/d_dialog.h>
#include <XRS/color.h>
#include <XRS/string_format.h>
#include <XRS/define.h>
#undef XRS_SOURCE


//************** class d_dialog ********************

#define extractZ(n,c,x) if(extractOpt(win.rDB,n,c,opt)) x=atoi(opt);if(x<1) x=1
#define extractI(n,c,x) if(extractOpt(win.rDB,n,c,opt)) x=atoi(opt);if(x<0) x=0
#define extractD(n,c,x) if(extractOpt(win.rDB,n,c,opt)) x=atof(opt);if(x<0)x=-x
#define extractS(n,c,x) if(extractOpt(win.rDB,n,c,opt)) copy_string(x,opt)


void d_dialog::initialize(){

//------------- fBtHgl̎擾  ---------------
   
   double D_Dialog_Step;
   char *D_Dialog_Color,*D_Dialog_Format,*D_Dialog_Font;
   D_Dialog_Color=D_Dialog_Format=D_Dialog_Font=NULL;

   D_Dialog_String =D_DIALOG_STRING;
   D_Dialog_Xoffset=D_DIALOG_XOFFSET;
   D_Dialog_Yoffset=D_DIALOG_YOFFSET;
   D_Dialog_Width  =D_DIALOG_WIDTH;
   D_Dialog_Height =D_DIALOG_HEIGHT;
   D_Dialog_Shape  =D_DIALOG_SHAPE;
   D_Dialog_Step   =D_DIALOG_STEP;
   copy_string(D_Dialog_Font,D_DIALOG_FONT);
   copy_string(D_Dialog_Color,D_DIALOG_COLOR);
   copy_string(D_Dialog_Format,D_DIALOG_FORMAT);

   char opt[126];

   extractZ("xrs.dialog.double.width",
            "Xrs.Dialog.Double.Width",D_Dialog_Width); 

   extractZ("xrs.dialog.double.height",
            "Xrs.Dialog.Double.Height",D_Dialog_Height); 

   extractI("xrs.dialog.double.xoffset",
            "Xrs.Dialog.Double.Xoffset",D_Dialog_Xoffset); 

   extractI("xrs.dialog.double.yoffset",
            "Xrs.Dialog.Double.Yoffset",D_Dialog_Yoffset); 

   extractI("xrs.dialog.double.shape",
            "Xrs.Dialog.Double.Shape",D_Dialog_Shape); 

   extractZ("xrs.dialog.double.string",
            "Xrs.Dialog.Double.String",D_Dialog_String);

   extractD("xrs.dialog.double.step",
            "Xrs.Dialog.Double.Step",D_Dialog_Step);

   extractS("xrs.dialog.double.color",
            "Xrs.Dialog.Double.Color",D_Dialog_Color);

   extractS("xrs.dialog.double.format",
            "Xrs.Dialog.Double.Format",D_Dialog_Format);

   extractS("xrs.dialog.double.font",
            "Xrs.Dialog.Double.Font",D_Dialog_Font);

//----------------------------------------------

   gc       = graphic_context(win,win.black,0,LineSolid,D_Dialog_Font);
   digit_gc = graphic_context(win,D_Dialog_Color,0,LineSolid,D_Dialog_Font);

   resize();
   
   step=D_Dialog_Step;
   format(D_Dialog_Format);

   delete [] D_Dialog_Font;   D_Dialog_Font=NULL;
   delete [] D_Dialog_Format; D_Dialog_Format=NULL;
   delete [] D_Dialog_Color;  D_Dialog_Color=NULL;
}


d_dialog::~d_dialog(){
   delete [] pformat;  pformat=NULL;
}


void d_dialog::resize(int i,int j,int s){
   
   if(i>0) D_Dialog_Width=i; if(j>0) D_Dialog_Height=j;
   if(s>=0) D_Dialog_Shape=s;
   
   switch(D_Dialog_Shape){ 
      case 0:  
        w=  D_Dialog_Width;    i1=1; i2=w-2; 
        h=2*D_Dialog_Height;   j1=j2=D_Dialog_Height; break;
      default:  
        w=2*D_Dialog_Width;    i1=i2=D_Dialog_Width;
        h=  D_Dialog_Height;   j1=1; j2=h-2;
   }   
}


void d_dialog::format(char *s){
  if(win.disp() && fw){
      char wanya[64]; int i;
      for(i=0;i<fw;i++) wanya[i]=' '; wanya[i]='\0';
      XDrawImageString(win.disp(),win,gc,i0+i1+D_Dialog_Xoffset,
                             j0+h-D_Dialog_Yoffset,wanya,fw); fw=0;
  }
  if(!s) return;  copy_string(pformat,s);
}


void d_dialog::parameter_draw(){
   if(win.disp()==NULL) return;
   char wanya[64],desu[64];
   int  i=parameter_string(wanya,desu,f,step,pformat);
   if(i>fw) fw=i;
   else{ for(;i<fw;i++) wanya[i]=desu[i]=' '; wanya[i]=desu[i]='\0';}

   XDrawImageString(win.disp(),win,gc,i0+i1+D_Dialog_Xoffset,
                    j0+h-D_Dialog_Yoffset,wanya,fw);
   XDrawString(win.disp(),win,digit_gc,i0+i1+D_Dialog_Xoffset,
                    j0+h-D_Dialog_Yoffset,desu,fw);
}

void d_dialog::draw(){
   if(win.disp()==NULL) return;
   static double f_old=f+1;
   if(f_old!=f){
     char wanya[64];
     int i=sprintf(wanya,pformat,f);
     if(i>fw) fw=i; else{ for(;i<fw;i++) wanya[i]=' '; wanya[i]='\0'; }
     
     XDrawImageString(win.disp(),win,gc,i0+i1+D_Dialog_Xoffset,
                                      j0+h-D_Dialog_Yoffset,wanya,fw);
     f_old=f;
   }
}

void d_dialog::checkevent()
{ 
   register int x=win.ev.xbutton.x,y=win.ev.xbutton.y; chev=0;
   if(x>i0 && x<i0+w && y>j0 && y<j0+h){
      register int n=win.ev.xbutton.button; 
      if(x<i0+i2 && y<j0+j2){
          switch(n){        /* parameter up */
            case 1: f+=step;     break;
            case 2: f+=step*0.1; break;
            case 3: step*=10.0;  break;   
            default:; 
          }
          chev=1;
      }else{
          switch(n){        /* parameter down */
            case 1: f-=step;     break;
            case 2: f-=step*0.1; break;
            case 3: step*=0.1;   break;   
            default:;
         }
         chev=2;
      }
      parameter_draw(); 
    }
}


void d_dialog::redraw(){
   if(win.disp()==NULL) return;
   char wanya[D_Dialog_String+1];
   ::string(wanya,name,D_Dialog_String);
   XDrawRectangle(win.disp(),win,gc,i0+1,j0+1,w-2,h-2);
   XDrawLine(win.disp(),win,gc,i0+i1,j0+j1,i0+i2,j0+j2);
   XDrawImageString(win.disp(),win,gc,
    i0+D_Dialog_Xoffset,j0+j2-D_Dialog_Yoffset,wanya,D_Dialog_String);
   parameter_draw();
   XFlush(win.disp());
}

