#define XRS_SOURCE
#include <XRS/control.h>
#include <XRS/string_format.h>
#include <XRS/define.h>
#undef XRS_SOURCE

//************* [JȊ֐ƕϐ̒` ****************

typedef enum {SAME,PUSHED,CHANGED}; // for control_window::list_state

static void            XRS_start_quit(int);
static void            XRS_pause_continue(int);
static control_window *XRS_start_window=NULL;
static dialog         *XRS_start_quit_dialog=NULL;
static dialog         *XRS_pause_continue_dialog=NULL;

//************** class control_window *******************

#define extractZ(n,c,x) if(extractOpt(rDB,n,c,opt)) x=atoi(opt);if(x<1) x=1
#define extractS(n,c,x) if(extractOpt(rDB,n,c,opt)) copy_string(x,opt)


void control_window::initialize(int i,int j,int st){

  //------------- fBtHgl̎擾 ---------------

   char *Control_Window_Title=NULL;
   int   Control_Window_Width,Control_Window_Height;

   Control_Window_Width=CONTROL_WINDOW_WIDTH;
   Control_Window_Height=CONTROL_WINDOW_HEIGHT;
   copy_string(Control_Window_Title,CONTROL_WINDOW_TITLE);

   char opt[126];

   extractZ("xrs.window.control.width",
            "Xrs.Window.Control.Width",Control_Window_Width);

   extractZ("xrs.window.control.height",
            "Xrs.Window.Control.Height",Control_Window_Height); 

   extractS("xrs.window.control.title",
            "Xrs.Window.Control.Title",Control_Window_Title);

  //----------------------------------------------

   list_state=SAME;
   if(i<1) imax=Control_Window_Width; else imax=i;
   if(j<1) jmax=Control_Window_Height; else jmax=j; 
   i0=j0=in=jn=is=js=0; realtime=0; 
   title(Control_Window_Title);
   eventmask(ButtonPressMask|ExposureMask);
   delete [] Control_Window_Title; Control_Window_Title=NULL;

   if(st && XRS_start_window==NULL){
      XRS_start_window=this; 

      XRS_start_quit_dialog=new f_dialog(*this,XRS_start_quit);
      XRS_start_quit_dialog->title("");
      redraw();

      XRS_pause_continue_dialog=new f_dialog(*this,XRS_pause_continue);
      XRS_pause_continue_dialog->title("pause");
      redraw();
   }
}


void control_window::draw(){
     for(ListIter<dialog*> P=p; !P.empty(); P.next()) P.curr()->redraw();
}


void control_window::redraw(){
   switch(list_state){
     case PUSHED:  
       draw(p[-1]); break;
     default:
       i0=j0=in=jn=is=js=0;  window::resize(1,1);
       for(ListIter<dialog*> P=p; !P.empty(); P.next()) draw(P.curr());
   }
   list_state=SAME;
}

void control_window::resize(int i,int j){
     if(i<1) i=imax; if(j<1) j=jmax;
     if(i==imax && j==jmax) return;
     imax=i; jmax=j;
     redraw();
}

void control_window::draw(dialog *pp){ 
     register int w,h,i,j;

     i=width(); j=height();
     w=pp->width(); h=pp->height();

     if(jmax<imax){
         if(j0+h>jmax+js){ j0=js; i0=in;}
         if(i0+w>imax+is){ j0=js=jn; i0=in=is;}
     }else{
         if(i0+w>imax+is){ i0=is; j0=jn;}
         if(j0+h>jmax+js){ i0=is=in; j0=jn=js;}
     }
     if(i0+w>in) in=i0+w;      if(i0+w>i) i=i0+w;
     if(j0+h>jn) jn=j0+h;      if(j0+h>j) j=j0+h;

     pp->move(i0,j0);
     if(jmax<imax) j0+=h;  else i0+=w;

     window::resize(i,j);
     draw();
}


control_window::control_window(window& W,
  int w,int h,int i,int j,int bw,int st):window(W,0,0,i,j,bw)
  { initialize(w,h,st); }

control_window::control_window(int w,int h,int st)
  :window(0,0){ initialize(w,h,st);}

control_window::~control_window(){
   dialog *tmp;
   for(ListIter<dialog*> P(p,-1); !P.empty();){
       tmp=P.curr(); P.prev(); delete tmp;  
   }
}


void control_window::checkevent(){
     chev=0;
     if(rtp.number())
        for(ListIter<dialog*> RTP=rtp; !RTP.empty(); RTP.next())
            RTP.curr()->draw();

     if(d && XCheckWindowEvent(d,win,evmask,&ev)){
         if( ev.type == Expose ){ draw();  return; }
         if( ev.type == ButtonPress ){
             chev=ev.xbutton.button; 
             for(ListIter<dialog*> EVP=evp; !EVP.empty(); EVP.next()) 
               EVP.curr()->checkevent();
         }
     }
}


void control_window::add(dialog &pp){
     p.push(&pp); 
     if(realtime) rtp.push(&pp);  else  evp.push(&pp);

     if(list_state==SAME) list_state=PUSHED;
     else                 list_state=CHANGED;
}


void  control_window::remove(dialog *pp){
     int n;

     n=rtp.number()-1;
     for(ListIter<dialog*> RTP(rtp,-1); !RTP.empty(); RTP.prev()){
       if(RTP.curr()==pp) break;
       n--;
     }
     if(n>=0) rtp.splice(n);

     n=evp.number()-1;
     for(ListIter<dialog*> EVP(evp,-1); !EVP.empty(); EVP.prev()){ 
       if(EVP.curr()==pp){ break;}
       n--; 
     }
     if(n>=0) evp.splice(n);

     n=p.number()-1;
     for(ListIter<dialog*> P(p,-1); !P.empty(); P.prev()){ 
       if(P.curr()==pp){ break;}
       n--; 
     }
     if(n>=0){ p.splice(n); list_state=CHANGED;}
}


void control_window::startup(void){
  if(XRS_start_window!=NULL) XRS_start_quit(0); 
}




//**************** ftHgCxg֐ ************************

void XRS_start_quit(int n){
    if(n==0){
      XRS_start_quit_dialog->title("start");
      XRS_start_quit_dialog->redraw();
      if(XRS_start_window->disp()!=NULL){
         while(XRS_start_window->ev.type != ButtonPress)
           XNextEvent(XRS_start_window->disp(),&XRS_start_window->ev);
      }
      XRS_start_quit_dialog->title("quit");
      for(ListIter<window*> i=XRS_list; !i.empty(); i.next()) i.curr()->draw();
      return;
    }
    exit(0);
}


void XRS_pause_continue(int){
    XRS_pause_continue_dialog->title("cont");
    XRS_pause_continue_dialog->redraw();
    if(XRS_start_window->disp()!=NULL)
      XWindowEvent(XRS_start_window->disp(),*XRS_start_window,ButtonPress,
                &XRS_start_window->ev);
    XRS_pause_continue_dialog->title("pause");
    for(ListIter<window*> i=XRS_list; !i.empty(); i.next()) i.curr()->draw();
}

