#define XRS_SOURCE
#include <XRS/c_dialog.h>
#include <XRS/color.h>
#include <XRS/string_format.h>
#include <XRS/define.h>
#include <Complex.h>
#undef XRS_SOURCE


//************** class c_dialog ********************

#define extractZ(n,c,x) if(extractOpt(win.rDB,n,c,opt)) x=atoi(opt);if(x<1) x=1
#define extractI(n,c,x) if(extractOpt(win.rDB,n,c,opt)) x=atoi(opt);if(x<0) x=0
#define extractD(n,c,x) if(extractOpt(win.rDB,n,c,opt)) x=atof(opt);if(x<0)x=-x
#define extractS(n,c,x) if(extractOpt(win.rDB,n,c,opt)) copy_string(x,opt)


void c_dialog::initialize(){

//------------- fBtHgl̎擾  ---------------
   
   double C_Dialog_Re_Step,C_Dialog_Im_Step;
   char *C_Dialog_Color,*C_Dialog_Format,*C_Dialog_Font;
   C_Dialog_Color=C_Dialog_Format=C_Dialog_Font=NULL;

   C_Dialog_String =C_DIALOG_STRING;
   C_Dialog_Xoffset=C_DIALOG_XOFFSET;
   C_Dialog_Yoffset=C_DIALOG_YOFFSET;
   C_Dialog_Width  =C_DIALOG_WIDTH;
   C_Dialog_Height =C_DIALOG_HEIGHT;
   C_Dialog_Shape  =C_DIALOG_SHAPE;
   C_Dialog_Re_Step=C_DIALOG_REAL_STEP;
   C_Dialog_Im_Step=C_DIALOG_IMAGINARY_STEP;
   copy_string(C_Dialog_Font,C_DIALOG_FONT);
   copy_string(C_Dialog_Color,C_DIALOG_COLOR);
   copy_string(C_Dialog_Format,C_DIALOG_FORMAT);

   char opt[126];

   extractZ("xrs.dialog.complex.width",
            "Xrs.Dialog.Complex.Width",C_Dialog_Width); 

   extractZ("xrs.dialog.complex.height",
            "Xrs.Dialog.Complex.Height",C_Dialog_Height); 

   extractI("xrs.dialog.complex.xoffset",
            "Xrs.Dialog.Complex.Xoffset",C_Dialog_Xoffset); 

   extractI("xrs.dialog.complex.yoffset",
            "Xrs.Dialog.Complex.Yoffset",C_Dialog_Yoffset); 

   extractI("xrs.dialog.complex.shape",
            "Xrs.Dialog.Complex.Shape",C_Dialog_Shape); 

   extractZ("xrs.dialog.complex.string",
            "Xrs.Dialog.Complex.String",C_Dialog_String); 

   extractD("xrs.dialog.complex.real.step",
            "Xrs.Dialog.Complex.Real.Step",C_Dialog_Re_Step); 

   extractD("xrs.dialog.complex.imagimary.step",
            "Xrs.Dialog.Complex.Imaginary.Step",C_Dialog_Im_Step); 

   extractS("xrs.dialog.complex.color",
            "Xrs.Dialog.Complex.Color",C_Dialog_Color);

   extractS("xrs.dialog.complex.format",
            "Xrs.Dialog.Complex.Format",C_Dialog_Format);

   extractS("xrs.dialog.complex.font",
            "Xrs.Dialog.Complex.Font",C_Dialog_Font);

//----------------------------------------------

   gc       = graphic_context(win,win.black,0,LineSolid,C_Dialog_Font);
   digit_gc = graphic_context(win,C_Dialog_Color,0,LineSolid,C_Dialog_Font);

   resize();

   step=Complex(C_Dialog_Re_Step,C_Dialog_Im_Step);
   polar_cordinate=0;
   format(C_Dialog_Format);

   delete [] C_Dialog_Font;   C_Dialog_Font=NULL;
   delete [] C_Dialog_Format; C_Dialog_Format=NULL;
   delete [] C_Dialog_Color;  C_Dialog_Color=NULL;
}


c_dialog::~c_dialog(){
   delete [] pformat;  pformat=NULL;
}


void c_dialog::resize(int i,int j,int s){
   if(i>0)  C_Dialog_Width=i; if(j>0) C_Dialog_Height=j;
   if(s>=0) C_Dialog_Shape=s;

   w=2*C_Dialog_Width; h=2*C_Dialog_Height; 
   i4=C_Dialog_Width;  j4=C_Dialog_Height;
   switch(C_Dialog_Shape){ 
      case 0:  
        i1=1; i2=i4; i3=w-2; i5=1;  
        j1=j3=j4;    j2=h-2; j5=j4;
        break;
      default:  
        j1=1; j2=j4; j3=h-2; j5=3*j4/2;
        i1=i3=i4;    i2=w-2; i5=1;
   }
}


void c_dialog::format(char *s){
  if(win.disp()){
      char wanya[64]; int i;
      if(real_fw){
          for(i=0;i<real_fw;i++) wanya[i]=' '; wanya[i]='\0';
          XDrawImageString(win.disp(),win,gc,i0+i1+C_Dialog_Xoffset,
                           j0+j1+j4-C_Dialog_Yoffset,wanya,real_fw); real_fw=0;
      }
      if(imag_fw){
          for(i=0;i<imag_fw;i++) wanya[i]=' '; wanya[i]='\0';
          XDrawImageString(win.disp(),win,gc,i0+i4+C_Dialog_Xoffset,
                           j0+h-C_Dialog_Yoffset,wanya,imag_fw); imag_fw=0;
      }
  }
  if(!s) return;  copy_string(pformat,s);  
}


void c_dialog::parameter_draw(){
   if(win.disp()==NULL) return;
   char wanya[64],desu[64];
   int i;

   i=(polar_cordinate?
           parameter_string(wanya,desu,abs(f)  ,step.real(),pformat):
           parameter_string(wanya,desu,f.real(),step.real(),pformat));
   if(i>real_fw) real_fw=i;
   else{ for(;i<real_fw;i++) wanya[i]=desu[i]=' '; wanya[i]=desu[i]='\0';}
   
   XDrawImageString(win.disp(),win,gc,i0+i1+C_Dialog_Xoffset,
                    j0+j1+j4-C_Dialog_Yoffset,wanya,real_fw);
   XDrawString(win.disp(),win,digit_gc,i0+i1+C_Dialog_Xoffset,
                    j0+j1+j4-C_Dialog_Yoffset,desu ,real_fw);

   i=(polar_cordinate?
        (f==0? parameter_string(wanya,desu,0.0        ,step.imag() ,pformat):
	       parameter_string(wanya,desu,arg(f)/M_PI,step.imag() ,pformat)):
               parameter_string(wanya,desu,f.imag()    ,step.imag(),pformat) );
   if(i>imag_fw) imag_fw=i;
   else{ for(;i<imag_fw;i++) wanya[i]=desu[i]=' '; wanya[i]=desu[i]='\0';}
   
   XDrawImageString(win.disp(),win,gc,i0+i4+C_Dialog_Xoffset,
                    j0+h-C_Dialog_Yoffset,wanya,imag_fw);
   XDrawString(win.disp(),win,digit_gc,i0+i4+C_Dialog_Xoffset,
                    j0+h-C_Dialog_Yoffset,desu ,imag_fw);
}

void c_dialog::draw(){
   if(win.disp()==NULL) return;
   static Complex f_old=f+1;
   if(f_old!=f){
     char wanya[64]; int i;
     
     i=(polar_cordinate? sprintf(wanya,pformat,abs(f)):
	                 sprintf(wanya,pformat,f.real()));
     if(i>real_fw) real_fw=i;
     else{ for(;i<real_fw;i++) wanya[i]=' '; wanya[i]='\0'; }

     XDrawImageString(win.disp(),win,gc,i0+i1+C_Dialog_Xoffset,
                           j0+j1+j4-C_Dialog_Yoffset,wanya,real_fw);

     i=(polar_cordinate?
	    (f==0? sprintf(wanya,pformat,0.0        ):
   	           sprintf(wanya,pformat,arg(f)/M_PI)):
	           sprintf(wanya,pformat,f.imag()   ));
     if(i>imag_fw) imag_fw=i;
     else{ for(;i<imag_fw;i++) wanya[i]=' '; wanya[i]='\0'; }	

     XDrawImageString(win.disp(),win,gc,i0+i4+C_Dialog_Xoffset,
                    j0+h-C_Dialog_Yoffset,wanya,imag_fw);
     f_old=f;
   }
}

void c_dialog::checkevent()
{ 
   register int x=win.ev.xbutton.x-i0,y=win.ev.xbutton.y-j0; chev=0;
   if(x>0 && x<w && y>0 && y<h){
      register int n=win.ev.xbutton.button;
      if(polar_cordinate){
         double argf; 
         if(f==0) argf=0; else argf=arg(f);
         if(x<i3 && y<j3){
            if(x<i2 && y<j2){
                switch(n){        /* parameter up */
                   case 1: f=polar(abs(f)+step.real()    ,argf); break;
                   case 2: f=polar(abs(f)+0.1*step.real(),argf); break;
                   case 3: step=Complex(step.real()*10.0,step.imag()); break; 
                   default:; 
                } chev=1;
            }else{
                switch(n){        /* parameter up */
                  case 1: f=polar(abs(f),argf+M_PI*step.imag()    );  break;
                  case 2: f=polar(abs(f),argf+0.1*M_PI*step.imag());  break;
                  case 3: step=Complex(step.real(),step.imag()*10.0); break;   
                  default:;
                } chev=2;
            }
         }else{
            if(x<i2 && y<j2){
                switch(n){        /* parameter down */
                  case 1: f=polar(abs(f)-step.real()    ,argf);  break;
                  case 2: f=polar(abs(f)-0.1*step.real(),argf);  break;
                  case 3: step=Complex(step.real()*0.1,step.imag()); break;   
                  default:; 
                } chev=3;
            }else{
                switch(n){        /* parameter down */
                  case 1: f=polar(abs(f),argf-M_PI*step.imag()    );  break;
                  case 2: f=polar(abs(f),argf-0.1*M_PI*step.imag());  break;
                  case 3: step=Complex(step.real(),step.imag()*0.1);  break;   
                  default:;
                } chev=4;
            }
         }
      }else{
         Complex s;
         if(x<i3 && y<j3){
            if(x<i2 && y<j2){
                switch(n){        /* parameter up */
                   case 1: s=step.real(); f+=s;   break;
                   case 2: s=step.real(); f+=s*0.1; break;
                   case 3: step=Complex(step.real()*10.0,step.imag()); break; 
                   default:; 
                } chev=1;
            }else{
                switch(n){        /* parameter up */
                  case 1: s=Complex(0,step.imag()); f+=s;      break;
                  case 2: s=Complex(0,step.imag()); f+=s*0.1;  break;
                  case 3: step=Complex(step.real(),step.imag()*10.0); break; 
                  default:;
                } chev=2;
            }
         }else{
            if(x<i2 && y<j2){
                switch(n){        /* parameter down */
                  case 1: s=step.real(); f-=s;      break;
                  case 2: s=step.real(); f-=s*0.1; break;
                  case 3: step=Complex(step.real()*0.1,step.imag()); break;   
                  default:; 
                } chev=3;
            }else{
                switch(n){        /* parameter down */
                  case 1: s=Complex(0,step.imag()); f-=s; break;
                  case 2: s=Complex(0,step.imag()); f-=s*0.1; break;
                  case 3: step=Complex(step.real(),step.imag()*0.1);  break;   
                  default:;
                } chev=4;
            }
         }
      }
      parameter_draw(); 
    }
}



void c_dialog::redraw(){
   if(win.disp()==NULL) return;
   char wanya[C_Dialog_String+1];
   ::string(wanya,name,C_Dialog_String);
   XDrawRectangle(win.disp(),win,gc,i0+1,j0+1,w-2,h-2);
   XDrawLine(win.disp(),win,gc,i0+i1,j0+j1,i0+i3,j0+j3);
   XDrawLine(win.disp(),win,gc,i0+i4,j0+j4,i0+i2,j0+j2);
   XDrawImageString(win.disp(),win,gc,
    i0+i5+C_Dialog_Xoffset,j0+j5-C_Dialog_Yoffset,wanya,C_Dialog_String);
   parameter_draw();
   XFlush(win.disp());
}

