#ifndef XRS_xcoloredit_color_H
#define XRS_xcoloredit_color_H
/* $Header: /usr/nfs/maple/d0/users/rlh2/toolkit/installed-src/xcoloredit/RCS/color.h,v 1.2 90/06/30 14:33:12 rlh2 Rel Locker: rlh2 $ */

/* color.h - color definitions
 * 
 * Author:	Christopher A. Kent
 * 		Western Research Laboratory
 * 		Digital Equipment Corporation
 * Date:	Sun Dec 13 1987
 * Copyright (c) 1987 Christopher A. Kent

 * $Log:	color.h,v $
 * Revision 1.2  90/06/30  14:33:12  rlh2
 * patchlevel 1
 * 
 * Revision 1.1  90/05/10  11:16:54  rlh2
 * Initial revision
 * 
 * Revision 1.2  88/06/30  09:58:56  mikey
 * Handles CMY also.
 * 
 * Revision 1.1  88/06/30  09:10:53  mikey
 * Initial revision
 */

#include <X11/Xlib.h>

struct RGB { unsigned short r, g, b; };
struct HSV { double	h, s, v;	/* [0, 1] */ };
struct CMY { unsigned short c, m, y; };

RGB	MixRGB(RGB,double,RGB,double);
RGB	MixHSV(RGB,double,RGB,double);
RGB	HSVToRGB(HSV);
HSV	RGBToHSV(RGB);
double RGBDist(RGB,RGB);
RGB	PctToRGB(double,double,double);
HSV	PctToHSV(double,double,double);
RGB	CMYToRGB(CMY);
CMY	RGBToCMY(RGB);
void RGBToXColor(RGB,XColor *);

#endif
