/*--------------------------------------------------------------------
   template class List & ListIter  
 ---------------------------------------------------------------------

 example:
      List<double> a;     double^Xg̐錾B
      double a[3];        RԖڂ̗vf
      int n=a.number();     vf
      a.unshift(3.5);       Xg̐擪 3.5 B
      double x=a.shift();   Xg̐擪vfP苎ĕԂB
      a.push(2.4);          Xg̍Ō 2.4 B
      double x=a.pop();     Xg̍ŌォvfP苎ĕԂB
      a.splice(3,4.0);      XĝRԖڂ 4.0 B
      a.splice(-2,5.1);     Xg̍ŌォQԖڂ 5.1 B
      double x=a.splice(1); XĝPԖڂ̗vf苎ĕԂB
      double x=a.splice(-2);Xg̍ŌォQԖڂ̗vf苎ĕԂB

      ListIter<double> i=a;  Xg̐擪̗vf𔽕q i ɃZbg
      ListIter i(a,2);       XĝQԖڂ̗vf𔽕q i ɃZbg
      ListIter i(a,-1);      Xg̍Ō̗vf𔽕q i ɃZbg

      for(ListIter i=a; !i.empty(); i.next()){   for[v
          double i.curr();                       ݂̗vf
	  }
-------------------------------------------------------------------------*/

#ifndef LIST_H_INCLUDE
#define LIST_H_INCLUDE

#include <stdio.h>

template <class T> class node{
  private:
    friend class List<T>;
    friend class ListIter<T>;
    T    p;
    node *next,*prev;
};


template <class T> class List{
  private: 
    int num;
    node<T> *head,*last;
    node<T> *seek(int) const;
    int create(T);
 public:
    List():num(0),head(0),last(0){}
    List(List<T>&);
    ~List();
    friend class ListIter<T>;
    List<T>& operator=(List<T> &);
    T& operator[](int);
    int  number(){ return num; }
    void splice(int,T);
    T splice(int);
    void push(T);
    T pop();
    void unshift(T);
    T shift();
    void debug() const;
};


template <class T> class ListIter{
  private:
     node<T> *current;
  public:
     ListIter(const List<T> &L,int n=0):current(L.seek(n)){}
     int  empty() const{ return current==0;}
     void next(){ current=current->next;} 
     void prev(){ current=current->prev;}
     T& curr() const{ return current->p;}
};


template <class T> void List<T>::debug() const{
    printf("head:%p prev=%p next=%p\n",head,head->prev,head->next);
	printf("last:%p prev=%p next=%p\n",last,last->prev,last->next);
    for(node<T> *tmp=head; tmp; tmp=tmp->next)
		printf("  %p: prev=%p next=%p\n",tmp,tmp->prev,tmp->next);
}

template <class T> List<T>::~List(){
   node<T> *next=0;
   for(node<T> *tmp=head; tmp; tmp=next){
      next=tmp->next;  delete tmp;  tmp=0; 
   }
   head=last=0; num=0; 
}


template <class T> List<T>::List(List<T> &s):head(0),last(0){
    for(node<T> *tmp=s.head; tmp; tmp=tmp->next) push(tmp->p);
}
    

template <class T> List<T>& List<T>::operator=(List<T> &s){
    if(this==&s) return *this;
    node<T> *next=0,*tmp;
    for(tmp=head; tmp; tmp=next){
         next=tmp->next;  delete tmp; tmp=0;
    }
    head=last=0; num=0;
    for(tmp=s.head; tmp; tmp=tmp->next) push(tmp->p);
    return s;
}


template <class T> int List<T>::create(T p){
   if(head){ 
     return 0;
   }else{
     head=new node<T>;
	 head->p=p;  head->prev=0; head->next=0;
     last=head;  
	 num++;
     return 1;
   }
}


template <class T> node<T>* List<T>::seek(int n) const{
   register int i;
   node<T> *tmp;
   if(n<0){ tmp=last; for(i=-1; i>n; i--) if(tmp) tmp=tmp->prev;}
   else   { tmp=head; for(i=0; i<n; i++)  if(tmp) tmp=tmp->next;} 
   return tmp;
}

template <class T> T& List<T>::operator[](int n){
   node<T> *tmp=seek(n);
   if(!tmp){ fprintf(stderr,
               "Error in template <class T> T& List<T>::operator[](int)"
               "The List does not have %d-th element.\n",n); exit(1);
   }
   return tmp->p;
}


template <class T> void List<T>::splice(int n,T p){
   node<T> *tmp=seek(n);
   node<T> *nn=new node<T>; nn->p=p;
   if(tmp==head){
	   unshift(p);
   }else if(tmp){
      nn->prev=tmp->prev;  nn->next=tmp;
	  tmp->prev=nn;
      (nn->prev)->next=nn;
      num++;
  }else{
      if(n<0) unshift(p); else push(p);
   }
}


template <class T> T List<T>::splice(int n){
   T p;
   node<T> *tmp=seek(n);
   if(tmp==head){
	   p=shift();
   }else if(tmp==last){
	   p=pop();
   }else if(tmp){
      (tmp->prev)->next=tmp->next;
      (tmp->next)->prev=tmp->prev;
      p=tmp->p;
      delete tmp; tmp=0;
	  num--;
   }else{
      if(n<0) p=shift(); else p=pop();
   }
   return p;
}


template <class T> void List<T>::push(T p){ 
   if(!create(p)){
      node<T> *nn=new node<T>; nn->p=p; 
      nn->prev=last; nn->next=last->next; last->next=nn; last=nn; 
      num++;
  }
}


template <class T> T List<T>::pop(){
   if(last){
      T p=last->p;
      node<T> *prev=last->prev;
      if(prev) prev->next=0; else head=0;
      delete last; last=prev; 
      num--;
      return p;
   }else{
      fprintf(stderr,"Error in template <class T> T void List<T>::pop().\n"
                     "The List has no elements.\n"); exit(1);
   }
}


template <class T> void List<T>::unshift(T p){
   if(!create(p)){
      node<T> *nn=new node<T>; nn->p=p;
      nn->next=head; nn->prev=head->prev; head->prev=nn; head=nn;
      num++;
  }
}


template <class T> T List<T>::shift(){
   if(head){
      T p=head->p;
      node<T> *next=head->next;
      if(next) next->prev=0; else last=0;
      delete head; head=next;
      num--;
      return p;
   }else{
      fprintf(stderr,"Error in template <class T> T void List<T>::shift().\n"
                     "The List has no elements.\n"); exit(1);
   }
}

#endif
