#ifndef XRS_Graphic_H
#define XRS_Graphic_H
	
#include <XRS/graphic.h>
#include <XRS/f_dialog.h>
#include <XRS/color_manipulater.h>
	
//*************** class Graphic_Window ̒` *********************

class Graphic_Window:public graphic_window{
 protected:
   f_dialog*    add(void (*)(int));		
 public:
   Graphic_Window(window &W,int w=0,int h=0,int ms=0,
         int i=0,int j=0,int bw=-1):
		 graphic_window(W,w,h,ms,i,j,bw){}
   Graphic_Window(int w=0,int h=0,int ms=0):
         graphic_window(w,h,ms){}
		 
   Graphic_Window& geometry(int w=0,int h=0,int ms=0,int i=-1,int j=-1)
        { resize(w,h,ms); move(i,j);  return *this; }
		
   //-------- << Zq̒` ---------
   Graphic_Window& operator<<(char *name)  {   title(name); return *this; }
   Graphic_Window& operator<<(void (*f)(int)){   add(f);    return *this; }
   Graphic_Window& operator<<(double (*f)(double))
                                       { color_function(f);  return *this; }

   //--------- }js[^[ MEMORY ̒` --------
   friend Graphic_Window& operator<<(Graphic_Window&,
                                     Graphic_Window&(*)(Graphic_Window &));
   friend Graphic_Window& MEMORY(Graphic_Window&);

   //--------- }js[^[ MONO,PHASE ̒` --------
   friend Graphic_Window& operator<<(Graphic_Window&,MONO_di);
   friend Graphic_Window& operator<<(Graphic_Window&,PHASE_di);

   //--------- }js[^[ COLOR ̒` --------
   friend Graphic_Window& operator<<(Graphic_Window&,COLOR_Pc);
   friend Graphic_Window& operator<<(Graphic_Window&,COLOR_A_Uli);
};


Graphic_Window& operator<<(Graphic_Window &s,
   Graphic_Window& (*f)(Graphic_Window &)){return f(s);}

Graphic_Window& MEMORY(Graphic_Window &s)
   {  if(!s.free_memory()) s.memory();  return s; }
   
Graphic_Window& operator<<(Graphic_Window &s,MONO_di m)
   { s.monotone(m.x,m.n); return s;}

Graphic_Window& operator<<(Graphic_Window &s,PHASE_di m)
   { s.phasetone(m.x,m.n); return s;}

Graphic_Window& operator<<(Graphic_Window &s,COLOR_Pc m)
   { s.color_resource(m.x); return s; }

Graphic_Window& operator<<(Graphic_Window &s,COLOR_A_Uli m)
   { s.color_pixel(m.x,m.n); return s;}

f_dialog* Graphic_Window::add(void (*f)(int)){
     f_dialog *pp=new f_dialog(*this,f); 
     pp->resize(mesh_size()*width(),mesh_size()*height());
     return pp;
}
#endif
