#define XRS_SOURCE
#include <XRS/vector_field.h>
#include  <XRS/string_format.h>
#include <XRS/color.h>
#include <XRS/define.h>
#undef XRS_SOURCE

#define extractD(n,c,x) if(extractOpt(W.rDB,n,c,opt)) x=atof(opt);if(x<0) x=0
#define extractI(n,c,x) if(extractOpt(W.rDB,n,c,opt)) x=atoi(opt);if(x<0) x=0
#define extractS(n,c,x) if(extractOpt(W.rDB,n,c,opt)) copy_string(x,opt) 

void vector_field::initialize(){
//------------- ǥեͤμ  ---------------
   char *Vector_Field_Arrow_Color=NULL,*Vector_Field_Mark_Color=NULL;
   arrow_x_mag =VECTOR_FIELD_ARROW_X_MAG;
   arrow_y_mag =VECTOR_FIELD_ARROW_Y_MAG;
   mark_radius=VECTOR_FIELD_MARK_RADIUS;
   copy_string(Vector_Field_Arrow_Color,VECTOR_FIELD_ARROW_COLOR);
   copy_string(Vector_Field_Mark_Color,VECTOR_FIELD_MARK_COLOR);

   char opt[126];
   extractD("xrs.vector_field.arrow.x.mag",
            "Xrs.Vector_Field.Arrow.X.Mag",arrow_x_mag); 

   extractD("xrs.vector_field.arrow.y.mag",
            "Xrs.Vector_Field.Arrow.Y.Mag",arrow_y_mag);

   extractI("xrs.vector_field.mark.radius",
            "Xrs.Vector_Field.Mark.Radius",mark_radius);

   extractS("xrs.vector_field.arrow.color",
            "Xrs.Vector_Field.Arrow.Color",Vector_Field_Arrow_Color);

   extractS("xrs.vector_field.mark.color",
            "Xrs.Vector_Field.Mark.Color",Vector_Field_Mark_Color);

//---------------------------------------------------

   arrow_gc=graphic_context(W,Vector_Field_Arrow_Color);
   mark_gc =graphic_context(W,Vector_Field_Mark_Color);
}


vector_field::vector_field(window &w,int ni,int nj,int mi,int mj)
:W(w),N(ni*nj){
   register int i,j;
   LP=new XPoint* [ni];
   P =new XPoint  [N];
  for(i=0; i<ni; i++) LP[i]=P+i*nj;

   for(i=0; i<ni; i++)
      for(j=0; j<nj; j++){ LP[i][j].x=i*mi; LP[i][j].y=j*mj;}
   initialize();
}


#define XMark(D,W,G,x,y) XDrawArc(D,W,G,x-mark_radius,y-mark_radius,\
                                  mark_radius<<1,mark_radius<<1,0,23040);
void vector_field::draw_arrow(int i,int j,double x,double y){
  register int i1,j1;
  i1=i+(int)(x*arrow_x_mag);
  j1=j-(int)(y*arrow_y_mag);
  XDrawLine(W.disp(),W,arrow_gc,i,j,i1,j1);
  XMark(W.disp(),W,mark_gc,i,j);
}


void vector_field::draw(double *X,double *Y){
  register int n;
  for(n=0; n<N; n++) draw_arrow(P[n].x,P[n].y,X[n],Y[n]);
}

