/*********** include **************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <XRS/color.h>
#include <XRS/Simple.h>

Display  *d;
GC       gc,bgc;
Colormap cm;
Simple_Window  win;

void help(){
printf(" This command shows a sample color disk of given brightness\n"); 
printf("according to color pixels which XRS::color_pixel(r,,brightness)\n");
printf("returns. ( 0<= r, brightness <= 1 )\n");
printf("\n");
printf(" how to use: colorsample [(float)brightness] [(int)windowsize]\n");
printf(" !This command consumes many colorcells of a workstation.\n");
exit(1);
}
            
void colormap(int,float);

/********** main ***********/

main(int argc,char *argv[])
{
    float bright;
    int    wide;
    unsigned long black,white;

    if( argc<=1 || argc >3 ) help();
    bright=atof(argv[1]);
	if( argc==3 )  wide=atoi(argv[2]);  else  wide=100;
	if( bright<0 || bright >1 ) help();

    win.geometry(wide,wide)<<"Color Sample";
    d = win.disp();
    cm=win.cm;
    gc = graphic_context("white");
    bgc = graphic_context("black");

    initialize();
    colormap(wide,bright);
    while(!win.chev) checkevent();
}



void colormap(int wide,float b)
{
   int i,j,size,center,radius;
   float r,theta;
   double x,y,s;
   unsigned long map;

   if(wide<20) return;
   size=wide-10;
   center=(int)((float)wide/2);
   radius=(int)((float)size/2);

   for(j=-center; j<center; j++){
      y=(double)j/radius;
      for(i=-center; i<center; i++){
          x=(double)i/radius;
          r=sqrt(x*x+y*y);
          if(x==0 && y==0) theta=0; else theta=atan2(y,x);  
          if(r>=1.0) continue;
          r=(float)(int)(r*8)/8;
          theta=((float)(int)(theta/(M_PI*2.0)*20))/20;
          map=color_pixel(theta,r,b);
          XSetForeground(d, gc, map);
          XDrawPoint(d, win, gc,i+center,center-j);
      }
   }

   XDrawArc(d,win,bgc,
       center-radius,center-radius,2*radius,2*radius,0,360*64);
   XDrawLine(d,win,bgc,center+radius-10,center,center+radius,center);
}





