/*==========================================================================
   Xwindow Realtime Simulator ver.3 Sample (2D dimulation)
   by kitsune(originated by sasa (originated by gutchi (originated in WTNB)))
============================================================================

  Kobayashi Model of crystal growth.

     tau*e*e*dP/dt = e*e*Laplacian(P)+P*(1-P)*(P-0.5+m(T)+disturb*RANSU)
     dT/dt = Laplacian(T)+K*dP/dt
     m(T) = alpha*Arctan(beta*(1-T))/PI 

  ! gnuplot ̃fBNgƃR}hĂ Exec gnuplot(`) 
    𐳂ύXĉB
     
---------------------------------------------------------------------------*/

/*********** include **************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <XRS/Control.h>
#include <XRS/DataSocket.h>
#include <XRS/Exec.h>

DataSocket Out("output");

//!!!! gnuplot ̃fBNgƃR}hĂύXĉB!!!!!
//!!!! {̎g gnuplot+ ł͂܂ȂƂ܂B!!!!!!!!!!!

//Exec gnuplot("gnuplot.old","gnuplot.old",NULL,"/dev/null");
                                // HP [NXe[V̏ꍇ
Exec gnuplot("gnuplot","gnuplot",NULL,"/dev/null");
                                // NEWS,LINUX,FeeBSD [NXe[V̏ꍇ



/*********** define ***************/

#define PI          M_PI
#define MAX         102         /* array size(x direction) */                  
#define MAY         102         /* array size(y direction) */
#define M(x)        (alpha*atan(beta*(1-x))/PI)
#define RANSU       (drand48()-0.5)
#define integer(x)  ((int)(floor(x)+floor(2*((x)-floor(x)))))


/*********** global variable ************/

double                  t;
double                  **P,**T;

double                  LX=1.5;
double                  LY=1.5;
double                  DT=0.0001;
double                  DX=0.03;
double                  quit_time=20000;

double                  alpha=0.9;
double                  beta=10.0;
double                  tau=3.0;
double                  K=1.50;
double                  e=0.01;
double                  disturb=0.2;
double                  r_start=0.15;

double                  rot_x=50,rot_z=50;
int                     i_max,j_max;
FILE                    *fp;

/********** function & class prototype *****************/

void                    initial(int);
void                    boundary(void);
void view(){ char s[56]; sprintf(s,"set view %f,%f",rot_x,rot_z); gnuplot<<s; }

Control_Window          Cwin,GP;


/********** main ***********/

main()
{
     int   quit_step;

     i_max = (int)(LX/DX);
     j_max = (int)(LY/DX);
     quit_step=integer(quit_time/DT);

     array(P,i_max+1,j_max+1);
     array(T,i_max+1,j_max+1);

/*----- initialize ----------*/

    Cwin<< t << initial <<PARAMETER<< alpha << beta << K << e 
        <<"t"<<"initial"<<"alpha"<<"beta"<<"K"<<"e";

    GP<<PARAMETER<<rot_x<<rot_z<<"rot_x"<<"rot_z";
    GP.title("gnuplot");

   view();
   gnuplot<<"set zrange [-0.1:1.2]";
   gnuplot<<"set hidden3d";
   gnuplot<<"set data style lines"; 
   gnuplot<<"set contour base";

   initialize();  
   initial(0);

   register int i,j,ts;

/*----- main routine --------*/

        while(1){

            checkevent();  if(GP.chev) view();

         for(ts=0; ts<10; ts++){
            double   T2[MAX][MAY],P2[MAX][MAY],P3[MAX][MAY];
            double   nl,dP,dT,tee,txx,txxp;
            tee=DT/(e*e*tau);
            txx=DT/(DX*DX);
            txxp=txx/tau;

/*----- P local map -----*/
            for(i=1;i<i_max;i++)
                for(j=1;j<j_max;j++){
                    nl=P[i][j]*(1-P[i][j])
                      *(P[i][j]-0.5+M(T[i][j])+disturb*RANSU);
                    P2[i][j]=P[i][j]+tee*nl;
                 }

/*----- P & T diffusion term -----*/

            for(i=1;i<i_max;i++)
                for(j=1;j<j_max;j++){
                    dP=P[i-1][j]+P[i+1][j]+P[i][j-1]+P[i][j+1]
                        -4.0*P[i][j];
                    P3[i][j]=P2[i][j]+txxp*dP;
                    dT=T[i-1][j]+T[i+1][j]+T[i][j-1]+T[i][j+1]
                        -4.0*T[i][j];
                    T2[i][j]=T[i][j]+txx*dT;
                }

/*----- T local map -----*/
            for(i=1;i<i_max;i++)
                for(j=1;j<j_max;j++){
                    T[i][j]=T2[i][j]+K*(P3[i][j]-P[i][j]);
                    if( T[i][j] < 0 ) T[i][j]=0.0;
                    P[i][j]=P3[i][j];
                }
            boundary();
          }
          t = t + 10*DT;

          gnuplot<<"splot '< datasocket output'";   
          Out.open();
          for(i=1;i<i_max;i+=2){
              for(j=1;j<j_max;j+=2) fprintf(Out,"%f\n",P[i][j]);
              fprintf(Out,"\n");
          }
          Out.close();
        }

        gnuplot<<"quit"; 
}


/************ boundary condition ************/

void boundary(void)
{
    register int i,j;

    for(j=1;j<j_max;j++){
        T[0][j]=T[1][j];
        T[i_max][j]=0;
        P[0][j]=P[1][j];
        P[i_max][j]=0;

    }
    for(i=1;i<i_max;i++){
        T[i][0]=T[i][1];
        T[i][j_max]=0;
        P[i][0]=P[i][1];
        P[i][j_max]=0;
    }
}


/*************** initialize function ************/

void initial(int)
{
    register int i,j;

    for(j=0; j<j_max+1; j++)
        for(i=1; i<i_max; i++){
            P[i][j] = 0;
            T[i][j] = 0;
        }

    for(j=0; j<j_max+1; j++)
        for(i=1; i<i_max; i++)
            if(((i-1)*(i-1)+(j-1)*(j-1))<(r_start/DX*r_start/DX)){
                T[i][j] = 1.0;
                P[i][j] = 1.0;
            }

    boundary();
    t=0;
}





    


