/*==========================================================================
   Xwindow Realtime Simulator ver.3 Sample 
   by kitsune(originated by sasa (originated by  gutchi (originated in WTNB)))
==========================================================================

      sinai map
          x <- x+y+delta*cos(2*pi*y) mod 1
          y <- x+2*y                 mod 1
  
---------------------------------------------------------*/


/*********** include **************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <XRS/Control.h>
#include <XRS/Graphic.h>


/*********** define ***************/

#define PI          M_PI
#define MAX         500
#define MAY         500
#define modulo(x)   ((x)-floor(x))


/*********** global variable ************/

int                     n=0;
int                     i_max;
static int              m[MAX][MAY];
double                  x=0.5,y=0.5;
double                  oldx,oldy;
double                  DX=0.005;
double                  delta=0.1;
double                  disp=1.0;


/********** function & class prototype *****************/

void  initial(int);
void  map(int);
Control_Window  Control;
Graphic_Window  Map,Count;


/********** main ***********/

main()
{
    i_max = (int)(1/DX);

    Control<<n<<"n"<< initial << map    <<PARAMETER<< delta << disp
                   <<"initial"<<"click!"<<"delta"<<"disp";
    Map.geometry(i_max,i_max,2)  <<"map";
    Count.geometry(i_max,i_max,2)<<"count";
   
    initialize();
 
    for(n=0; n<1000000; n++){
        oldx=x;
        oldy=y;
        x=modulo(oldx+oldy+delta*cos(2*PI*oldy));
        y=modulo(oldx+2*oldy);
        m[(int)(x/DX)][(int)(y/DX)]++;

        checkevent();
        Map.draw_point(2,(int)(x/DX),(int)(y/DX));
    }
}


/********* window initialize function **************/

void initial(int)
{
    register i,j; n=0;
    for(i=0; i<i_max; i++)
        for(j=0; j<i_max; j++){
            m[i][j]=0;
        }
    Map.clear();
    Count.clear();
}
          

/********* draw count density **************/

void map(int n)
{
    register i,j;
    double w;

    for(i=0; i<i_max; i++)
       for(j=0; j<i_max; j++){
           w=disp*(double)m[i][j]/(double)n;
           Count.draw_point(w,i,j);
       }
}

