#define XRS_SOURCE
#include <XRS/plane.h>
#include <XRS/string_format.h>
#include <XRS/define.h>
#undef XRS_SOURCE

#ifdef NOINLINE
#define INLINE 
#else
#define INLINE inline
#endif

//************** class plane window ********************

unsigned long mask[32]={0x00000001,0x00000003,0x00000007,0x0000000f,
                        0x0000001f,0x0000003f,0x0000007f,0x000000ff,
                        0x000001ff,0x000003ff,0x000007ff,0x00000fff,
                        0x00001fff,0x00003fff,0x00007fff,0x0000ffff,
                        0x0001ffff,0x0003ffff,0x0007ffff,0x000fffff,
                        0x001fffff,0x003fffff,0x007fffff,0x00ffffff,
                        0x01ffffff,0x03ffffff,0x07ffffff,0x0fffffff,
                        0x1fffffff,0x3fffffff,0x7fffffff,0xffffffff};

INLINE int  no_flag(unsigned long c,int k){ return (c&(1<<k))==0;}
INLINE void flag_up(unsigned long &c,int k){ c|=(1<<k);}
INLINE void flag_down(unsigned long &c,int k){ c&=~(1<<k);}
INLINE int  lowest_flag(unsigned long c)
{   register int i=-1;  if(c){ while(!(c&mask[++i]));} return i; }


void plane_window::initialize(int i,int j,int ms){

//------------- fBtHgl̎擾  ---------------

   #define extractZ(n,c,x) if(extractOpt(rDB,n,c,opt)) x=atoi(opt);if(x<1) x=1
   #define extractD(n,c,x) if(extractOpt(rDB,n,c,opt)) x=atof(opt); \
                         if(x<0) x=0;  if(x>1) x=1
   #define extractS(n,c,x) if(extractOpt(rDB,n,c,opt)) copy_string(x,opt)
   
   int Plane_Window_Meshsize;
   char *Plane_Window_Color_Type=NULL;
   Plane_Window_Maxcolor=NULL;
   Plane_Window_Mincolor=NULL;
   Plane_Window_Color_Resource=NULL;
   Plane_Window_Color_Type=NULL;
			 
   Plane_Window_Meshsize    =PLANE_WINDOW_MESHSIZE;
   Plane_Window_Color_Number=PLANE_WINDOW_COLOR_NUMBER;
   Plane_Window_Color_H     =PLANE_WINDOW_COLOR_H;
   copy_string(Plane_Window_Maxcolor,PLANE_WINDOW_MAXCOLOR);
   copy_string(Plane_Window_Mincolor,PLANE_WINDOW_MINCOLOR);
   copy_string(Plane_Window_Color_Resource,PLANE_WINDOW_COLOR_RESOURCE);
   copy_string(Plane_Window_Color_Type,PLANE_WINDOW_COLOR_TYPE);

   char opt[126];

   extractZ("xrs.window.plane.meshsize",
            "Xrs.Window.Plane.Meshsize",Plane_Window_Meshsize);

   extractZ("xrs.window.plane.color_number",
            "Xrs.Window.Plane.Color_Number",Plane_Window_Color_Number); 

   extractD("xrs.window.plane.color_h",
            "Xrs.Window.Plane.Color_H",Plane_Window_Color_H);

   extractS("xrs.window.plane.maxcolor",
            "Xrs.Window.Plane.Maxcolor",Plane_Window_Maxcolor);

   extractS("xrs.window.plane.mincolor",
            "Xrs.Window.Plane.Mincolor",Plane_Window_Mincolor);

   extractS("xrs.window.plane.color_resource",
            "Xrs.Window.Plane.Color_Resource",Plane_Window_Color_Resource);

   extractS("xrs.window.plane.color_type",
            "Xrs.Window.Plane.Color_Type",Plane_Window_Color_Type);

//----------------------------------------------

   if(i<1)  imax=1;  else imax=i;
   if(j<1)  jmax=1;  else jmax=j;
   if(ms<1) meshsize=Plane_Window_Meshsize; else meshsize=ms;
   simple_window::resize(imax*meshsize,jmax*meshsize);

   p=NULL;
   gc =graphic_context(*this,black);
   bgc=graphic_context(*this,black);
   wgc=graphic_context(*this,white);

   if(Plane_Window_Color_Number>30) Plane_Window_Color_Number=30;
   color    =NULL;
   if     (!strcmp(Plane_Window_Color_Type,"monotone"))      
                                              monotone();
   else if(!strcmp(Plane_Window_Color_Type,"phasetone"))     
                                              phasetone();
   else if(!strcmp(Plane_Window_Color_Type,"color_resource"))
                                              color_resource();
   else                                       color_pixel(NULL,0);

   old_color=NULL; memory();
   register int ii,jj;
   for(ii=0; ii<imax; ii++)
       for(jj=0; jj<jmax; jj++) old_color[ii][jj]=0;

   delete [] Plane_Window_Color_Type; Plane_Window_Color_Type=NULL;
}

plane_window::~plane_window(){ 
   if(Plane_Window_Maxcolor!=NULL)
    { delete [] Plane_Window_Maxcolor; Plane_Window_Maxcolor=NULL;}
   if(Plane_Window_Mincolor!=NULL)
    { delete [] Plane_Window_Mincolor; Plane_Window_Mincolor=NULL;}
   if(color!=NULL)
    { delete [] color; color=NULL;}
   free_memory();
}

void plane_window::redraw(){
   if(d && old_color!=NULL && map_state){
      register ip,jp,im,jm,i,j,k;
      for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++){
             k=lowest_flag(old_color[i][j]);
             if(k>=0){
               XSetForeground(d, gc, color[k]);
               im=i*meshsize; jm=j*meshsize;
               for(ip=0; ip<meshsize; ip++)
                  for(jp=0; jp<meshsize; jp++)
                      XDrawPoint(d, win, gc, im+ip, jm+jp);
             }
         }
   }
}


void plane_window::resize(int ii,int jj,int ms){
    if(ii<1) ii=imax;
    if(jj<1) jj=jmax;
    if(ms<1) ms=meshsize;
    if(imax==ii && jmax==jj && meshsize==ms) return;
    if(old_color!=NULL){
       register int i,j;
       unsigned long **oc; array(oc,ii,jj);
       for(i=0; i<ii; i++)
          for(j=0; j<jj; j++){
             if(i>=imax || j>=jmax) oc[i][j]=0;
             else                   oc[i][j]=old_color[i][j];
          }
       delete [] old_color; old_color=oc;
    }
    imax=ii; jmax=jj; meshsize=ms;
    simple_window::resize(ii*ms,jj*ms);
    redraw();
}


INLINE void plane_window::drawpoint(int c,int i,int j){
      register ip,jp,im,jm;
      if( c > colornumber ) c=colornumber;
      if( c < 0           ) c=colornumber+1;

      if(old_color!=NULL){
          if(old_color[i][j] & mask[c]){ flag_up(old_color[i][j],c); return;}
          flag_up(old_color[i][j],c);
      }

      XSetForeground(d, gc, color[c]);
      im=i*meshsize; jm=j*meshsize;
      for(ip=0; ip<meshsize; ip++)
         for(jp=0; jp<meshsize; jp++)
             XDrawPoint(d, win, gc, im+ip, jm+jp);
}


INLINE void plane_window::erasepoint(int c,int i,int j){
      register ip,jp,im,jm;

      if( c > colornumber ) c=colornumber;
      if( c < 0           ) c=colornumber+1;

      if(old_color!=NULL){
          if(no_flag(old_color[i][j],c)) return;
          if(c){
            if(old_color[i][j] & mask[c-1])
              { flag_down(old_color[i][j],c);  return;}
          }
          flag_down(old_color[i][j],c);
      }

      im=i*meshsize; jm=j*meshsize;
      for(ip=0; ip<meshsize; ip++)
         for(jp=0; jp<meshsize; jp++)
             XDrawPoint(d, win, wgc, im+ip, jm+jp);

      if(old_color!=NULL){
         c=lowest_flag(old_color[i][j]);
         if(c<0) return;
         XSetForeground(d, gc, color[c]);
         im=i*meshsize; jm=j*meshsize;
         for(ip=0; ip<meshsize; ip++)
            for(jp=0; jp<meshsize; jp++)
                XDrawPoint(d, win, gc, im+ip, jm+jp);
      }
}


void plane_window::draw_point(int W,int i,int j){
      if(d==NULL || i<0 || i>=imax || j<0 || j>=jmax) return; 
      drawpoint(W,i,j);
}


void plane_window::erase_point(int W,int i,int j){
      if(d==NULL || i<0 || i>=imax || j<0 || j>=jmax) return;
      erasepoint(W,i,j);
}


void plane_window::draw_line(int W,int i1,int j1,int i2,int j2){
      if(d==NULL) return;
      register int i,j;
      double t,dt;
      dt=sqrt((i2-i1)*(i2-i1)+(j2-j1)*(j2-j1));
      if(dt) dt=0.7/dt; else return;
      for(t=0; t<1.0; t+=dt){
         i=(int)(t*(i2-i1))+i1; j=(int)(t*(j2-j1))+j1;
         if( i>=0 && i<imax && j>=0 && j<jmax) drawpoint(W,i,j);
      }
}


void plane_window::erase_line(int W,int i1,int j1,int i2,int j2){
      if(d==NULL) return;
      register int i,j;
      double t,dt;
      dt=sqrt((i2-i1)*(i2-i1)+(j2-j1)*(j2-j1));
      if(dt) dt=0.7/dt; else return;
      for(t=0; t<1.0; t+=dt){
         i=(int)(t*(i2-i1))+i1; j=(int)(t*(j2-j1))+j1;
         if( i>=0 && i<imax && j>=0 && j<jmax) erasepoint(W,i,j);
      }
}


void plane_window::draw_circle(int W,int i1,int j1,double r){
      if(d==NULL) return;
      register int i,j;
      double t,dt;
      if(r) dt=0.7/r; else return;
      for(t=0; t<2*M_PI; t+=dt){
         i=(int)(r*cos(t)+i1);   j=(int)(r*sin(t)+j1);
         if( i>=0 && i<imax && j>=0 && j<jmax)  drawpoint(W,i,j);
      }
}


void plane_window::erase_circle(int W,int i1,int j1,double r){
      if(d==NULL) return;
      register int i,j;
      double t,dt;
      if(r) dt=0.7/r; else return;
      for(t=0; t<2*M_PI; t+=dt){
         i=(int)(r*cos(t)+i1);   j=(int)(r*sin(t)+j1);
         if( i>=0 && i<imax && j>=0 && j<jmax)  erasepoint(W,i,j);
      }
}


void  plane_window::draw_2D(int **W){
      if(d==NULL) return;
      register int i,j;      
      for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++) drawpoint(W[i][j],i,j);
}


void  plane_window::erase_2D(int **W){
      if(d==NULL) return;
      register int i,j;      
      for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++) erasepoint(W[i][j],i,j);
}


void plane_window::clear(){
    if(old_color!=NULL){ 
       register int i,j;
       for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++) old_color[i][j]=0;
    }
    if(d) XClearWindow(d,win);
}


void  plane_window::clear(int W){
      if(d==NULL) return;
      register int i,j;      
      for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++) erasepoint(W,i,j);
}


unsigned long** plane_window::memory()
{   if(old_color==NULL){
       register int i,j; 
       array(old_color,imax,jmax);
       for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++) old_color[i][j]=0;
    }
    return old_color;   
}


int plane_window::free_memory(){
    if(old_color==NULL) return 0;
    delete_array(old_color); return 1;
}


void plane_window::color_pixel(unsigned long *cc,int n,char *cp,char *cn){
    if(color!=NULL){ delete [] color; color=NULL; colornumber=0;}

    if(n>30) n=30; if(n<0) n=0;  color=new unsigned long [n+2];
    for(register int i=0; i<n; i++)  color[i]=cc[i];
    colornumber=n;

    if(cp==NULL) color[n]=::color_pixel(*this,Plane_Window_Maxcolor);
    else         color[n]=::color_pixel(*this,cp);

    if(cn==NULL) color[n+1]=::color_pixel(*this,Plane_Window_Mincolor);
    else         color[n+1]=::color_pixel(*this,cn);
}

void plane_window::free_color_pixel(unsigned long *cp,int n){
    if(cp!=NULL){ XFreeColors(d,cm,cp,n,0); cp=NULL; }
    else{ XFreeColors(d,cm,color,colornumber+2,0); color=NULL; colornumber=0;}
}

void plane_window::monotone(double h,int n){
    if(n<1)         n=Plane_Window_Color_Number;
    if(h<0 || h>1)  h=Plane_Window_Color_H;
    unsigned long *c=new unsigned long [n];
    int i; for(i=0; i<n; i++) c[i]=::color_pixel(*this,h,(double)i/n,1);
    color_pixel(c,n);
    delete [] c; c=NULL;
}


void plane_window::phasetone(double h,int n){
    if(n<1)         n=Plane_Window_Color_Number;
    if(h<0 || h>=1) h=Plane_Window_Color_H;
    unsigned long *c=new unsigned long [n];
    int i; for(i=0; i<n; i++) c[i]=::color_pixel(*this,h+(0.5+i)/n,1,1);
    color_pixel(c,n);
    delete [] c; c=NULL;
}


void plane_window::color_resource(char *color_resource){
    unsigned long *c; int n;
    if(color_resource!=NULL) n=::color_pixel(*this,c,color_resource); 
    else      n=::color_pixel(*this,c,Plane_Window_Color_Resource);
    color_pixel(c,n);
    delete [] c; c=NULL;
}


//**************** J[TvEBhE **************************

void sample_window(plane_window &w)
{
     if(w.disp()==NULL) return;
     register i,j,sj,c,k;
     double mono,sashi,ss;
     GC bgc = graphic_context(w,w.black);
     c=w.color_number();

     for( j=0; j<w.j_max(); j++)
         for( i=0; i<w.i_max(); i++){
           k=(int)(32*i/w.i_max()); 
           if(k<c) w.draw_point(k,i,j);
         }

     mono=(double)w.width()/8;
     sashi=mono/4;

     for(j=1; j<32; j++){
         ss=j*sashi;
         sj=(int)(floor(ss)+floor(2*(ss-floor(ss))));
         XDrawLine(w.disp(),w,bgc,sj,0,sj,5);
     }

     for(j=1; j<4; j++){
         ss=j*mono;     
         sj=(int)(floor(ss)+floor(2*(ss-floor(ss))));
         XDrawLine(w.disp(),w,bgc,sj,0,sj,10);
     }
}

