#define XRS_SOURCE
#include <XRS/graphic.h>
#include <XRS/string_format.h>
#include <XRS/define.h>
#undef XRS_SOURCE

#ifdef NOINLINE
#define INLINE 
#else
#define INLINE inline
#endif

//************** class graphic window ********************

double  XRS_default_color_function(double x){ return(x*x*AMPF);}


#define extractZ(n,c,x) if(extractOpt(rDB,n,c,opt)) x=atoi(opt);if(x<1) x=1
#define extractD(n,c,x) if(extractOpt(rDB,n,c,opt)) x=atof(opt); \
                         if(x<0) x=0;  if(x>1) x=1
#define extractS(n,c,x) if(extractOpt(rDB,n,c,opt)) copy_string(x,opt)


void graphic_window::initialize(int i,int j,int ms){

//------------- fBtHgl̎擾  ---------------
   
   int Graphic_Window_Meshsize;
   char *Graphic_Window_Color_Type=NULL;
   Graphic_Window_Maxcolor=NULL;
   Graphic_Window_Mincolor=NULL;
   Graphic_Window_Color_Resource=NULL;
       
   Graphic_Window_Meshsize    =GRAPHIC_WINDOW_MESHSIZE;
   Graphic_Window_Color_Number=GRAPHIC_WINDOW_COLOR_NUMBER;
   Graphic_Window_Color_H     =GRAPHIC_WINDOW_COLOR_H;
   copy_string(Graphic_Window_Maxcolor,GRAPHIC_WINDOW_MAXCOLOR);
   copy_string(Graphic_Window_Mincolor,GRAPHIC_WINDOW_MINCOLOR);
   copy_string(Graphic_Window_Color_Resource,GRAPHIC_WINDOW_COLOR_RESOURCE);
   copy_string(Graphic_Window_Color_Type,GRAPHIC_WINDOW_COLOR_TYPE);

   char opt[126];

   extractZ("xrs.window.graphic.meshsize",
            "Xrs.Window.Graphic.Meshsize",Graphic_Window_Meshsize);

   extractZ("xrs.window.graphic.color_number",
            "Xrs.Window.Graphic.Color_Number",Graphic_Window_Color_Number); 

   extractD("xrs.window.graphic.color_h",
            "Xrs.Window.Graphic.Color_H",Graphic_Window_Color_H);

   extractS("xrs.window.graphic.maxcolor",
            "Xrs.Window.Graphic.Maxcolor",Graphic_Window_Maxcolor);

   extractS("xrs.window.graphic.mincolor",
            "Xrs.Window.Graphic.Mincolor",Graphic_Window_Mincolor);

   extractS("xrs.window.graphic.color_resource",
            "Xrs.Window.Graphic.Color_Resource",Graphic_Window_Color_Resource);

   extractS("xrs.window.graphic.color_type",
            "Xrs.Window.Graphic.Color_Type",Graphic_Window_Color_Type);

//----------------------------------------------

   if(i<1)  imax=1;  else imax=i;
   if(j<1)  jmax=1;  else jmax=j;
   if(ms<1) meshsize=Graphic_Window_Meshsize; else meshsize=ms;
   simple_window::resize(imax*meshsize,jmax*meshsize);

   p=NULL;
   gc =graphic_context(*this,black);
   bgc=graphic_context(*this,black);
   wgc=graphic_context(*this,white);

   color    =NULL;
   if     (!strcmp(Graphic_Window_Color_Type,"monotone"))      
                                              monotone();
   else if(!strcmp(Graphic_Window_Color_Type,"phasetone"))     
                                              phasetone();
   else if(!strcmp(Graphic_Window_Color_Type,"color_resource"))
                                              color_resource();
   else                                       color_pixel(NULL,0);

   old_color=NULL; memory();
   colorfunc=XRS_default_color_function;

   delete [] Graphic_Window_Color_Type; Graphic_Window_Color_Type=NULL;
}

graphic_window::~graphic_window(){ 
   if(Graphic_Window_Maxcolor!=NULL)
    { delete [] Graphic_Window_Maxcolor; Graphic_Window_Maxcolor=NULL;}
   if(Graphic_Window_Mincolor!=NULL)
    { delete [] Graphic_Window_Mincolor; Graphic_Window_Mincolor=NULL;}
   if(color!=NULL)
    { delete [] color; color=NULL;}
   free_memory();
}

void graphic_window::redraw(){
   if(d && old_color!=NULL && map_state){
      register ip,jp,im,jm,i,j;
      for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++){
             XSetForeground(d, gc, old_color[i][j]);
             im=i*meshsize; jm=j*meshsize;
             for(ip=0; ip<meshsize; ip++)
                for(jp=0; jp<meshsize; jp++)
                    XDrawPoint(d, win, gc, im+ip, jm+jp);
         }
   }
}


void graphic_window::clear(){
    if(old_color!=NULL){ 
       register int i,j;
       for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++) old_color[i][j]=white;
    }
    if(d) XClearWindow(d,win);
}


void graphic_window::resize(int ii,int jj,int ms){
    if(ii<1) ii=imax;
    if(jj<1) jj=jmax;
    if(ms<1) ms=meshsize;
    if(imax==ii && jmax==jj && meshsize==ms) return;
    if(old_color!=NULL){
       register int i,j;
       unsigned long **oc; array(oc,ii,jj);
       for(i=0; i<ii; i++)
          for(j=0; j<jj; j++){
             if(i>=imax || j>=jmax) oc[i][j]=white;
             else                   oc[i][j]=old_color[i][j];
          }
       delete [] old_color; old_color=oc;
    }
    imax=ii; jmax=jj; meshsize=ms;
    simple_window::resize(ii*ms,jj*ms);
    redraw();
}


INLINE void graphic_window::drawpoint(int c,int i,int j){
      register ip,jp,im,jm;
      unsigned long  newcp;

      if( c > colornumber ) c=colornumber;
      if( c < 0         ) c=colornumber+1;
      newcp = color[c];
      
      if(old_color!=NULL){
          if(newcp == old_color[i][j]) return;
          old_color[i][j] = newcp;
      }
      XSetForeground(d, gc, newcp);
      im=i*meshsize; jm=j*meshsize;
      for(ip=0; ip<meshsize; ip++)
         for(jp=0; jp<meshsize; jp++)
             XDrawPoint(d, win, gc, im+ip, jm+jp);
}


INLINE void graphic_window::point(int c,int i,int j){
      if(d==NULL || i<0 || i>=imax || j<0 || j>=jmax) return; 
      drawpoint(c,i,j);
}

INLINE void graphic_window::line(int c,int i1,int j1,int i2,int j2){
      if(d==NULL) return;
      register int i,j;
      double t,dt;
      dt=sqrt((i2-i1)*(i2-i1)+(j2-j1)*(j2-j1));
      if(dt) dt=0.7/dt; else return;
      for(t=0; t<1.0; t+=dt){
         i=(int)(t*(i2-i1))+i1; j=(int)(t*(j2-j1))+j1;
         if( i>=0 && i<imax && j>=0 && j<jmax) drawpoint(c,i,j);
      }
}

INLINE void graphic_window::circle(int c,int i1,int j1,double r){
      if(d==NULL) return;
      register int i,j;
      double t,dt;
      if(r) dt=0.7/r; else return;
      for(t=0; t<2*M_PI; t+=dt){
         i=(int)(r*cos(t)+i1);   j=(int)(r*sin(t)+j1);
         if( i>=0 && i<imax && j>=0 && j<jmax) drawpoint(c,i,j);             
      }
}


void graphic_window::draw_point(double W,int i,int j){
      point((int)(colorfunc(W)*colornumber),i,j);
}

void graphic_window::draw_line(double W,int i1,int j1,int i2,int j2){
      line((int)(colorfunc(W)*colornumber),i1,j1,i2,j2);
}

void graphic_window::draw_circle(double W,int i1,int j1,double r){
      circle((int)(colorfunc(W)*colornumber),i1,j1,r);
}


void  graphic_window::draw_2D(double **W){
      if(d==NULL) return;
      register int i,j;      
      for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++)
              drawpoint((int)(colorfunc(W[i][j])*colornumber),i,j);
}

void  graphic_window::draw_2D(int **c){
      if(d==NULL) return;
      register int i,j;      
      for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++) drawpoint(c[i][j],i,j);
}


unsigned long** graphic_window::memory()
{   if(old_color==NULL){
       register int i,j; 
       array(old_color,imax,jmax);
       for(i=0; i<imax; i++)
          for(j=0; j<jmax; j++) old_color[i][j]=white;
    }
    return old_color;   
}


int graphic_window::free_memory(){
    if(old_color==NULL) return 0;
    delete_array(old_color); return 1;
}


void graphic_window::color_pixel(unsigned long *cc,int n,char *cp,char *cn){
    if(color!=NULL){ delete [] color; color=NULL; colornumber=0;}

    if(n<0) n=0;  color=new unsigned long [n+2];
    for(register int i=0; i<n; i++)  color[i]=cc[i];
    colornumber=n;

    if(cp==NULL) color[n]=::color_pixel(*this,Graphic_Window_Maxcolor);
    else         color[n]=::color_pixel(*this,cp);

    if(cn==NULL) color[n+1]=::color_pixel(*this,Graphic_Window_Mincolor);
    else         color[n+1]=::color_pixel(*this,cn);
}

void graphic_window::free_color_pixel(unsigned long *cp,int n){
    if(cp!=NULL){ XFreeColors(d,cm,cp,n,0); cp=NULL; }
    else{ XFreeColors(d,cm,color,colornumber+2,0); color=NULL; colornumber=0;}
}

void graphic_window::monotone(double h,int n){
    if(n<1)         n=Graphic_Window_Color_Number;
    if(h<0 || h>1)  h=Graphic_Window_Color_H;
    unsigned long *c=new unsigned long [n];
    int i; for(i=0; i<n; i++) c[i]=::color_pixel(*this,h,(double)i/n,1);
    color_pixel(c,n);
    delete [] c; c=NULL;
}


void graphic_window::phasetone(double h,int n){
    if(n<1)         n=Graphic_Window_Color_Number;
    if(h<0 || h>=1) h=Graphic_Window_Color_H;
    unsigned long *c=new unsigned long [n];
    int i; for(i=0; i<n; i++) c[i]=::color_pixel(*this,h+(0.5+i)/n,1,1);
    color_pixel(c,n);
    delete [] c; c=NULL;
}


void graphic_window::color_resource(char *color_resource){
    unsigned long *c; int n;
    if(color_resource!=NULL) n=::color_pixel(*this,c,color_resource); 
    else      n=::color_pixel(*this,c,Graphic_Window_Color_Resource);
    color_pixel(c,n);
    delete [] c; c=NULL;
}


//**************** J[TvEBhE **************************

void sample_window(graphic_window &w)
{
     if(w.disp()==NULL) return;
     register i,j,m,sj;
     double mono,sashi,ss;
     GC bgc = graphic_context(w,w.black);

     for( j=0; j<w.j_max(); j++)
         for( i=0; i<w.i_max(); i++) w.draw_point((double)i/w.i_max(),i,j);

     mono=(double)w.width()/2;
     sashi=mono/5;

     for(j=1; j<10; j++){
         ss=j*sashi;
         sj=(int)(floor(ss)+floor(2*(ss-floor(ss))));
         XDrawLine(w.disp(),w,bgc,sj,0,sj,5);
     }
     
     m=(int)(floor(mono)+floor(2*(mono-floor(mono))));
     XDrawLine(w.disp(),w,bgc,m,0,m,10);
}

