#define XRS_SOURCE
#include <XRS/color.h>
#include <XRS/xcoloredit_color.h>
#include <XRS/string_format.h>
#include <XRS/XResource.h>
#include <XRS/define.h>
#undef XRS_SOURCE


//*****************  J[sNZ ***************************


unsigned long color_pixel(window &W,double h,double s,double v)
{
     if( h>1 || h<0 ) h-=floor(h);
     HSV hsv; hsv.h=h; hsv.s=s; hsv.v=v;
     RGB rgb=HSVToRGB(hsv);
     XColor cc;
     RGBToXColor(rgb,&cc);
     if(W.disp()!=NULL && !XAllocColor(W.disp(),W.cm,&cc)){
        fprintf(stderr,"Error: A color could not be allocated.\n"
                       "The number of colors exceeds the limits!\n");
     }
     return cc.pixel;
}


unsigned long color_pixel(window &W,char* name)
{
     XColor   cc;
     if(W.disp()!=NULL){
       if(!XParseColor(W.disp(),W.cm,name,&cc)){
         printf("Color request fails. No color has a such name\n");
         exit(1);
       }

       if(!XAllocColor(W.disp(),W.cm,&cc)){
         fprintf(stderr,"Error: A color could not be allocated.\n"
                       "The number of colors exceeds the limits!\n");
       }
     }
     return cc.pixel;
}


int color_pixel(window &W,unsigned long *&color,char *color_resource)
{
      register int n,i;
      char buffer[256],*colorname=NULL,*filename=NULL;
      unsigned long cp[256];
      FILE *file;

      if(color_resource==NULL){
         //------------- fBtHgl̎擾  ---------------
         char opt[126];
         copy_string(filename,XRS_COLOR_RESOURCE);
         if(extractOpt(W.rDB,"xrs.color_resource",
                             "Xrs.Color_Resource",opt))
                             copy_string(filename,opt);
      }else{
         copy_string(filename,color_resource);
      }

      if((file=fopen(filename,"r"))==NULL){
             printf("%s can't open.\n",filename); exit(1);
      }
      delete [] filename; filename=NULL;

      for(n=0;n<256;n++){
          if(fgets(buffer,sizeof(buffer),file)==NULL){ break;}
          /*--- remove spaces on top ----*/
          i=0; while(buffer [i]==' '){ ++i; } colorname=buffer+i;
          /*--- skip a empty line and a comment line ----*/
          if(colorname[0]=='\n' || colorname[0]=='!'){ n--; continue; };
          /*--- remove spaces at end -----*/
          i=strlen(colorname)-1; if(colorname[i]=='\n'){ colorname[i]=' '; i--;}
 
          while(colorname[i]==' '){ --i; } colorname[i+1]='\0';

          cp[n]=color_pixel(W,colorname);
      }

      color=new unsigned long [n];
      for(i=0; i<n; i++) color[i]=cp[i];

      fclose(file);
      return n;
}


unsigned long color_pixel(double h,double s,double v)
{     return color_pixel(XRS_ROOT,h,s,v);}

unsigned long color_pixel(char* name)
{     return color_pixel(XRS_ROOT,name);}

int color_pixel(unsigned long *&color,char *color_resource)
{     return color_pixel(XRS_ROOT,color,color_resource);}



//***************** OtBbNReLXg ***********************
   
GC graphic_context(window &W,unsigned long color,
                   unsigned int line_width,int line_style,char* font)
{
     GC g=NULL;
     Display *d=W.disp();
     Font dfont;
     unsigned long white=W.white;
     char *fontname=NULL;
     int  cap_style=CapButt,join_style=JoinMiter;

     if(d==NULL) return g;
     if(font==NULL){
         //------------- fBtHgl̎擾  ---------------
         char opt[126];
         copy_string(fontname,XRS_FONT);
         if(extractOpt(W.rDB,"xrs.font","Xrs.Font",opt))
                              copy_string(fontname,opt);
     }else{
         copy_string(fontname,font);
     }

     dfont = XLoadFont(d, fontname);     
     delete [] fontname; fontname=NULL;

     g = XCreateGC(d,RootWindow(d, 0),0,0);
     XSetLineAttributes(W.disp(),g,line_width,line_style,cap_style,join_style);
     XSetForeground(d, g, color);
     XSetBackground(d, g, white);
     XSetFont(d, g, dfont);
     return g;
}


int graphic_context(window &W,GC *&g,char *color_resource)
{
      register int i,n;
      unsigned long *c;

      n=color_pixel(W,c,color_resource);
      g=new GC [n];
      for(i=0; i<n; i++)  g[i]=graphic_context(W,c[i]);

      delete [] c;
      return n;
}


GC graphic_context(unsigned long color,
      unsigned int line_width,int line_style,char* font)
{     return graphic_context(XRS_ROOT,color,line_width,line_style,font); }

int graphic_context(GC *&g,char *color_resource)
{     return graphic_context(XRS_ROOT,g,color_resource);}



GC graphic_context(window &W,char *colorname,
      unsigned int line_width,int line_style,char* font)
{     return graphic_context(W,color_pixel(W,colorname)
                              ,line_width,line_style,font); }

GC graphic_context(char *colorname,
     unsigned int line_width,int line_style,char* font)
{  return graphic_context(XRS_ROOT,colorname,line_width,line_style,font); }


//====================================================================
//  FipxjƖOaxiajAIɕςfBXN
//  ̃J[sNZzpӂ֐Ƃ̐Fԍ߂֐
//====================================================================

unsigned long* colordisk(window &W,int ni,int nj){
    unsigned long *cp=new unsigned long [ni*nj];
    int i,j;
    for(i=0; i<ni; i++)
        for(j=0; j<nj; j++)
            cp[i*nj+j]=color_pixel(W,(double)j/nj,(double)i/ni,1);
    return cp;
}    


unsigned long* colordisk(int ni,int nj){
    return colordisk(XRS_ROOT,ni,nj);
}


int diskcolor(double r,double phi,int ni,int nj){
    static double norm=1.0/(2*M_PI);
    phi*=norm;  if( phi>=1 || phi<0 ) phi-=floor(phi);
    return (int)(nj*((int)(r*ni)+phi));
}


