#include <ctype.h>
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <XRS/XResource.h>

extern "C" gethostname();

static char *getHomeDir(char *dest){
    int uid;
    struct passwd *pw;
    register char *ptr;

    if((ptr=(char*)getenv("HOME"))!=NULL){
    	(void)strcpy(dest,ptr);
    }else{
    	if((ptr=(char*)getenv("USR"))!=NULL){
    		pw=getpwnam(ptr);
    	}else{
    		uid=getuid();
    		pw=getpwuid(uid);
    	}
    	if(pw) (void)strcpy(dest,pw->pw_dir);
    	else   *dest='\0';
    }
    return dest;
}


void mergeDatabases(Display *d,XrmDatabase &rDB,char *file)
{
    if(d==NULL){ rDB=NULL; return;}
    XrmDatabase homeDB=NULL,serverDB=NULL,currentDB=NULL;
    char filenamebuf[1024];
    char *filename=&filenamebuf[0];
    char *environment;
    
    XrmInitialize();

    if(XResourceManagerString(d)!=NULL){
    	serverDB=XrmGetStringDatabase(XResourceManagerString(d));
    }else{
    	(void)getHomeDir(filename);
    	(void)strcat(filename,"/.Xdefaults");
         serverDB=XrmGetFileDatabase(filename);
    }
    XrmMergeDatabases(serverDB,&rDB);

    if((environment=(char*)getenv("XENVIRONMENT"))==NULL){
    	int len;
    	(void)getHomeDir(filename);
    	(void)strcat(filename,"/.Xdefaults-");
    	len=strlen(filename);
    	(void)gethostname(filename+len,1024-len);
        homeDB=XrmGetFileDatabase(filename);
    }else{
    	homeDB=XrmGetFileDatabase(environment);
    }
    XrmMergeDatabases(homeDB,&rDB);

    currentDB=XrmGetFileDatabase(file);
    XrmMergeDatabases(currentDB,&rDB);
}


int extractOpt(XrmDatabase &rDB,char *str_name,char *str_class,char *opt)
{   
    if(rDB==NULL) return 0; 
    XrmValue value;
    char *str_type[20];

    if(XrmGetResource(rDB,str_name,str_class,str_type,&value)==True){
        (void)strncpy(opt,value.addr,(int)value.size);
        return 1;
    }else{
        return 0;
    }
}

