#ifndef XRS_window_H
#define XRS_window_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <XRS/XResource.h>
#include <XRS/List.h>
#include <XRS/Array.h>
#undef Complex
	
void initialize(void);	
void checkevent(void);


//***************** class window ̒` **************************

class window{
   void          initialize(int,int,int,int);
   int           w,h;
   char          *name;
 protected:
   int           evmask;
   int           map_state;
   Display       *d;
   Window        win,r;
   friend class  dialog;
   virtual void  add(dialog &){}
   virtual void  remove(dialog *){}

   friend void initialize(void);	
   friend void checkevent(void);
   virtual void  startup(){}
 public:
   XEvent        ev;
   XrmDatabase   rDB;
   Colormap      cm;
   unsigned long black,white;
   int           chev;
   window(char *,char * =NULL);
   window(window &,int,int,int=0,int=0,int=-1,int=1);
   window(int,int,int=1);
   virtual ~window();
   operator Window()        { return win;   }
   Display* disp()          { return d;     }
   Window   root()          { return r;     }
   int      width()         { return w; }
   int      height()        { return h; }
   void     move(int =-1,int =-1);
   char*    title()         { return name;  }
   void     title(char *);
   int      eventmask(void) { return evmask;}
   void     eventmask(int i){ if(d && r){ evmask=i; XSelectInput(d,win,evmask);} }
   void     map(void);
   void     unmap(void){ if(d && r && map_state) XUnmapWindow(d,win); map_state=0;}
   void     resize(int=0,int=0);

   virtual void  checkevent(){
	 chev=0;       
     if(d && XCheckWindowEvent(d,win,evmask,&ev) && ev.type==ButtonPress)
	    chev=ev.xbutton.button;
   }
   virtual void  draw(){}
   virtual void  redraw(){}
};


//**************** O[oϐ̐錾 **************************
   
#ifdef XRS_SOURCE
extern window          XRS_ROOT;
extern List<window*>   XRS_list;
extern int             XRS_map;

#else
  #ifdef XRSBG
  window          XRS_ROOT("&");
  #else
  window          XRS_ROOT(NULL);
  #endif
List<window*>   XRS_list;
int             XRS_map=0;
#endif

#endif
