#ifndef XRS_plane_H
#define XRS_plane_H
	
#include <XRS/simple.h>

//*************** class plane_window ̒` *********************

class plane_window: public simple_window{
 protected:
   //--- XResource ------------
     char*  Plane_Window_Maxcolor;
     char*  Plane_Window_Mincolor;
     char*  Plane_Window_Color_Resource;
     int    Plane_Window_Color_Number;
     double Plane_Window_Color_H;
  //-------------------------
   int      meshsize,imax,jmax,colornumber;
   void     initialize(int,int,int);
   unsigned long *color;
   unsigned long **old_color;
   void     drawpoint(int,int,int);
   void     erasepoint(int,int,int);
 public:
   GC gc;
   plane_window(window &W,int w=0,int h=0,int ms=0,
     int i=0,int j=0,int bw=-1)
     :simple_window(W,w,h,i,j,bw){initialize(w,h,ms);}
   plane_window(int w=0,int h=0,int ms=0)
     :simple_window(w,h){  initialize(w,h,ms);}
   ~plane_window();

   int        i_max()    { return imax;}
   int        j_max()    { return jmax;}
   int        mesh_size(){ return meshsize;}
   void       resize(int=0,int=0,int=0);
   void       clear();
   void       clear(int);
   
   void       redraw();
   
   void       color_pixel(unsigned long *,int,char* =NULL,char* =NULL);
   void       free_color_pixel(unsigned long * =NULL,int =0);
   unsigned long *color_pixel(){ return color;}
   int        color_number(){ return colornumber; }

   unsigned long** memory();
   int        free_memory();
   
   void       draw_point(int,int,int);
   void       erase_point(int,int,int);

   void       draw_line(int,int,int,int,int);
   void       erase_line(int,int,int,int,int);
   
   void       draw_circle(int,int,int,double);
   void       erase_circle(int,int,int,double);
   
   void       draw_2D(int **);
   void       erase_2D(int **);
   
   void       monotone(double=-1,int=0);
   void       phasetone(double=-1,int=0);
   void       color_resource(char * =NULL);
};

void sample_window(plane_window &);

#endif
