#ifndef XRS_graphic_H
#define XRS_graphic_H
	
#include <XRS/simple.h>

//*************** class graphic_window ̒` *********************

class graphic_window: public simple_window{
 protected:
   //--- XResource ------------
     char*  Graphic_Window_Maxcolor;
     char*  Graphic_Window_Mincolor;
     char*  Graphic_Window_Color_Resource;
     int    Graphic_Window_Color_Number;
     double Graphic_Window_Color_H;
  //-------------------------
   int  meshsize,imax,jmax,colornumber;
   void initialize(int,int,int);
   unsigned long *color;
   unsigned long **old_color;
   double (*colorfunc)(double);
   void     drawpoint(int,int,int);
 public:
   GC gc;
   graphic_window(window &W,int w=0,int h=0,int ms=0,
     int i=0,int j=0,int bw=-1)
	 :simple_window(W,w,h,i,j,bw){ initialize(w,h,ms); }
   graphic_window(int w=0,int h=0,int ms=0)
     :simple_window(w,h){ initialize(w,h,ms); }
   ~graphic_window();

   int        i_max()    { return imax;}
   int        j_max()    { return jmax;}
   int        mesh_size(){ return meshsize;}
   void       color_function(double (*f)(double)){ colorfunc=f;}
   void       resize(int=0,int=0,int=0);
   void       clear();
   
   void       redraw();
   
   void       color_pixel(unsigned long *,int,char* =NULL,char* =NULL);
   void       free_color_pixel(unsigned long * =NULL,int =0);
   unsigned long *color_pixel(){ return color;}
   int        color_number(){ return colornumber; }

   unsigned long** memory();
   int        free_memory();
   
   void       draw_point(double,int,int);
   void       draw_line(double,int,int,int,int);
   void       draw_circle(double,int,int,double);
   
   void       point(int,int,int);
   void       line(int,int,int,int,int);
   void       circle(int,int,int,double);

   void       draw_2D(double **);
   void       draw_2D(int **);
   
   void       monotone(double=-1,int=0);
   void       phasetone(double=-1,int=0);
   void       color_resource(char * =NULL);
};

void sample_window(graphic_window &);

#endif
