#ifndef XRS_Plane_H
#define XRS_Plane_H

#include <XRS/color_manipulater.h>
#include <XRS/plane.h>
#include <XRS/f_dialog.h>

	
//*************** class Plane_Window ̒` *********************

class Plane_Window:public plane_window{
 protected:
   f_dialog*    add(void (*)(int));		
 public:
   Plane_Window(window &W,int w=0,int h=0,int ms=0,
         int i=0,int j=0,int bw=-1):
		 plane_window(W,w,h,ms,i,j,bw){}
   Plane_Window(int w=0,int h=0,int ms=0):
         plane_window(w,h,ms){}
		 
   Plane_Window& geometry(int w=0,int h=0,int ms=0,int i=-1,int j=-1)
        { resize(w,h,ms); move(i,j);  return *this; }
		
   //-------- << Zq̒` ---------
   Plane_Window& operator<<(char *name)  {   title(name); return *this; }
   Plane_Window& operator<<(void (*f)(int)){   add(f);    return *this; }

   //--------- }js[^[ MEMORY ̒` --------
   friend Plane_Window& operator<<(Plane_Window&,
                                     Plane_Window&(*)(Plane_Window &));
   friend Plane_Window& MEMORY(Plane_Window&);

   //--------- }js[^[ MONO,PHASE ̒` --------
   friend Plane_Window& operator<<(Plane_Window&,MONO_di );
   friend Plane_Window& operator<<(Plane_Window&,PHASE_di);

   //--------- }js[^[ COLOR ̒` --------
   friend Plane_Window& operator<<(Plane_Window&,COLOR_Pc);
   friend Plane_Window& operator<<(Plane_Window&,COLOR_A_Uli);
};


Plane_Window& operator<<(Plane_Window &s,
   Plane_Window& (*f)(Plane_Window &)){return f(s);}

Plane_Window& MEMORY(Plane_Window &s)
   {  if(!s.free_memory()) s.memory();  return s; }
   
Plane_Window& operator<<(Plane_Window &s,MONO_di m)
   { s.monotone(m.x,m.n); return s;}

Plane_Window& operator<<(Plane_Window &s,PHASE_di m)
   { s.phasetone(m.x,m.n); return s;} 

Plane_Window& operator<<(Plane_Window &s,COLOR_Pc m)
   { s.color_resource(m.x); return s;}

Plane_Window& operator<<(Plane_Window &s,COLOR_A_Uli m)
   { s.color_pixel(m.x,m.n); return s;}

f_dialog* Plane_Window::add(void (*f)(int)){
     f_dialog *pp=new f_dialog(*this,f); 
     pp->resize(mesh_size()*width(),mesh_size()*height());
     return pp;
}
#endif
