#ifndef XRS_Control_H
#define XRS_Control_H

#include <XRS/control.h>
#include <XRS/d_dialog.h>
#include <XRS/i_dialog.h>
	

//***************** class Control_Window ̒` **************************


class Control_Window:public control_window{
 protected:
   List<dialog*> dlist;
   List<char*>   slist;
   int d_list(dialog *);
   int s_list(char *);
   f_dialog*    add(void (*)(int),char * ="");
   d_dialog*    add(double &,char * ="");
   i_dialog*    add(int &,char * ="");
 public:
   Control_Window(window &W,int w=0,int h=0,int i=0, int j=0,int bw=-1,
         int st=1):control_window(W,w,h,i,j,bw,st){ realtime=1; }
   Control_Window(int w=0,int h=0,int st=1):
		 control_window(w,h,st){ realtime=1; }

   Control_Window& geometry(int w=0,int h=0,int i=-1,int j=-1)
            { resize(w,h); move(i,j); return *this;}
   Control_Window& operator<<(void (*f)(int)){ d_list(add(f));return *this;}
   Control_Window& operator<<(double &s)     { d_list(add(s));return *this;}
   Control_Window& operator<<(int &s)        { d_list(add(s));return *this;}
   Control_Window& operator<<(char *name)    { s_list(name);  return *this;}
					   
   friend Control_Window& operator<<(Control_Window&,
                                     Control_Window&(*)(Control_Window &));
   friend Control_Window& PARAMETER(Control_Window&);
};

int Control_Window::d_list(dialog *p){
    if(slist.number()){
	   p->title(slist.shift()); return  0;
	}else{
	   dlist.push(p); return  1;
	}
}

int Control_Window::s_list(char *s){
    if(dlist.number()){
	   dialog *p=dlist.shift(); p->title(s); return  0;
	}else{
	   slist.push(s); return  1;
	}
}
	  

f_dialog* Control_Window::add(void (*f)(int),char *s){
     int rt=realtime; realtime=0;
     f_dialog *pp=new f_dialog(*this,f);  
     redraw(); pp->title(s);
     realtime=rt;
     return pp;
}

d_dialog* Control_Window::add(double &x,char *s){
     d_dialog *pp=new d_dialog(*this,x); 
     if(realtime) pp->digit_gc=pp->gc; 
     redraw(); pp->title(s);
     return pp;
}

i_dialog* Control_Window::add(int &x,char *s){
     i_dialog *pp=new i_dialog(*this,x); 
     if(realtime) pp->digit_gc=pp->gc;  
     redraw(); pp->title(s);
     return pp;
}


Control_Window& operator<<(Control_Window &s,
             Control_Window& (*f)(Control_Window &)){return f(s);}

Control_Window& PARAMETER(Control_Window &s)
            { s.realtime=!s.realtime;  return s; }

#endif
