#ifndef XRS_Complex_Control_H
#define XRS_Complex_Control_H

#include <XRS/c_dialog.h>
#include <XRS/d_dialog.h>
#include <XRS/i_dialog.h>
#include <XRS/control.h>
	
//************ class Complex_Control_window ̒` *********************

class Complex_Control_Window:public control_window{
 protected:
   int pol;
   List<dialog*> dlist;
   List<char*>   slist;
   int d_list(dialog *);
   int s_list(char *);
   f_dialog*    add(void (*)(int),char * ="");
   d_dialog*    add(double &,char * ="");
   i_dialog*    add(int &,char * ="");
   c_dialog*    add(Complex &,char * ="",int=0);
 public:
   Complex_Control_Window(window &W,int w=0,int h=0,
         int i=0,int j=0,int bw=-1,int st=1):
         control_window(W,w,h,i,j,bw,st),pol(0){ realtime=1;}
   Complex_Control_Window(int w=0,int h=0,int st=1):
		 control_window(w,h,st),pol(0){ realtime=1;} 

   Complex_Control_Window& geometry(int w=0,int h=0,int i=-1,int j=-1)
   { resize(w,h);  move(i,j);     return *this; }
   Complex_Control_Window& operator<<(void (*f)(int))     
                                       { d_list(add(f)); return *this;}
   Complex_Control_Window& operator<<(double &s)
                                       { d_list(add(s)); return *this;}
   Complex_Control_Window& operator<<(int &s)
                                       { d_list(add(s)); return *this;}
   Complex_Control_Window& operator<<(Complex &s)
                                       { d_list(add(s,"",pol)); return *this;}
   Complex_Control_Window& operator<<(char *name)
                                       { s_list(name);      return *this;}
   
   friend Complex_Control_Window& operator<<(Complex_Control_Window&,
                  Complex_Control_Window& (*)(Complex_Control_Window &));
   friend Complex_Control_Window& PARAMETER(Complex_Control_Window&);
   friend Complex_Control_Window& PC(Complex_Control_Window&);
   friend Complex_Control_Window& RC(Complex_Control_Window&);
};


int Complex_Control_Window::d_list(dialog *p){
    if(slist.number()){
	   p->title(slist.shift()); return  0;
	}else{
	   dlist.push(p); return  1;
	}
}


int Complex_Control_Window::s_list(char *s){
    if(dlist.number()){
	   dialog *p=dlist.shift(); p->title(s); return  0;
	}else{
	   slist.push(s); return  1;
	}
}


c_dialog* Complex_Control_Window::add(Complex &x,char *s,int pol){
     c_dialog *pp=new c_dialog(*this,x); 
     if(realtime) pp->digit_gc=pp->gc;  
     if(pol) pp->polar_cordinate=!(pp->polar_cordinate);
     redraw();  pp->title(s);
     return pp;
}

d_dialog* Complex_Control_Window::add(double &x,char *s){
     d_dialog *pp=new d_dialog(*this,x);
     if(realtime) pp->digit_gc=pp->gc; 
     redraw();  pp->title(s);
     return pp;
}

i_dialog* Complex_Control_Window::add(int &x,char *s){
     i_dialog *pp=new i_dialog(*this,x); 
     if(realtime) pp->digit_gc=pp->gc;  
     redraw();  pp->title(s);
     return pp;
}

f_dialog* Complex_Control_Window::add(void (*f)(int),char *s){
     int rt=realtime; realtime=0;
     f_dialog *pp=new f_dialog(*this,f); 
     redraw();  pp->title(s);
	 realtime=rt;
     return pp;
}

Complex_Control_Window& operator<<(Complex_Control_Window &s,
   Complex_Control_Window& (*f)(Complex_Control_Window &)){ return f(s);}

Complex_Control_Window& PARAMETER(Complex_Control_Window &s)
{   s.realtime=!s.realtime;  return s; }

Complex_Control_Window& PC(Complex_Control_Window &s)
{   s.pol=1; return s; }

Complex_Control_Window& RC(Complex_Control_Window &s)
{   s.pol=0; return s; }

#endif
