#include <XRS/Socket.h>
#include <sys/socket.h>
#include <stdio.h>
#include <sys/stat.h> 

extern "C" socket();
extern "C" bind();
extern "C" listen();
extern "C" accept();
extern "C" connect();

Socket::Socket(char *ss):ns(0){
   if(!access(ss,F_OK)){
      struct stat file; stat(ss,&file);
      if((file.st_mode&S_IFMT)!=S_IFSOCK && (file.st_mode&S_IFMT)!=S_IFIFO){
        fprintf(stderr,"Error: Socket \"%s\" can't open.\n"
        "A file with the same name exists, which isn't a socket.\n",ss); 
        exit(1);
      }
   }

   strcpy(address,ss);
   unlink(address);
   saun.sun_family=AF_UNIX;
   strcpy(saun.sun_path,address);
   len=sizeof(saun.sun_family)+strlen(saun.sun_path)+1;
   if((s=socket(AF_UNIX,SOCK_STREAM,0))<0)
      { perror("server: can't make a socket."); exit(1);}
   if(bind(s,(sockaddr *)&saun,len)<0)
      { perror("server: can't bind.");   exit(1);}
   if(listen(s,5)<0)
      { perror("server: can't listen."); exit(1);}
}
   
Socket::~Socket(){ 
   if(ns) close();  ::close(s);  
   if(!access(address,F_OK)){
      struct stat file; stat(address,&file);
      if((file.st_mode&S_IFMT)==S_IFSOCK || (file.st_mode&S_IFMT)==S_IFIFO)
          unlink(address);
   }
}

int Socket::open(){
   if((ns=accept(s,(sockaddr *)&saun,&fromlen))<0)
     { perror("server: can't accept clients."); exit(1);}
   return ns;
}


ClientSocket::ClientSocket(char *address){
   saun.sun_family=AF_UNIX;
   strcpy(saun.sun_path,address);
   len=sizeof(saun.sun_family)+strlen(saun.sun_path)+1;
   if((s=socket(AF_UNIX,SOCK_STREAM,0))<0){
      fprintf(stderr,"client: can't make a socket of \"%s\".\n",address);
      exit(1);
   }
   if(connect(s,(sockaddr *)&saun,len)<0){
      fprintf(stderr,
              "client: can't connect the server through \"%s\".\n",address); 
      exit(1); 
   }
};









