#include <XRS/Exec.h>
#include <sys/param.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>

extern "C" int pipe();
extern "C" int dup();
extern "C" int  fork();
extern "C" void execvp();
extern "C" void close();
static char **strip(char *);

Exec::Exec(char *path,char *command,char *outfile,char *errfile):in(NULL){
   if(pipe(infilds)==EOF )
     { fprintf(stderr,"%s: can't make a pipe.\n",command);  exit(1); }

   if( !fork() ){
      if(outfile){ close(1);  out=fopen(outfile,"w"); }
      if(errfile){ close(2);  err=fopen(errfile,"w"); }

      close(infilds[1]);
      close(0);  dup(infilds[0]);
      close(infilds[0]);

      execvp(path,strip(command));
   }

   close(infilds[0]);
   in=fdopen(infilds[1],"w"); 
}
   
Exec::~Exec(){ fflush(in); fclose(in); close(infilds[1]); }

char ** strip(char *s){
   register int i=0,k=0,m=0;
   char **c; char *p;

   while(s[i]!='\0'){ if(s[i++]!=' '){ if(!m) k++; m++;}else{ m=0;} } 

   c=new char* [k+1];
   i=0; p=s; k=0; m=0;
   do{
     if(s[i]==' ' || s[i]=='\0'){ 
         if(m){
           c[k]=new char[m]; 
           strncpy(c[k++],p,m); 
         } m=0; p=s+i+1;
     }else{
         m++; 
     }
   }while(s[i++]!='\0');

   c[k]=0;
   return c;
}

